/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.context;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialResponseWriter
extends ResponseWriterWrapper {
    private boolean inChanges = false;
    private boolean inInsertBefore = false;
    private boolean inInsertAfter = false;
    ResponseWriter writer;
    public static final String RENDER_ALL_MARKER = "javax.faces.ViewRoot";
    public static final String VIEW_STATE_MARKER = "javax.faces.ViewState";

    public PartialResponseWriter(ResponseWriter writer) {
        this.writer = writer;
    }

    @Override
    public ResponseWriter getWrapped() {
        return this.writer;
    }

    @Override
    public void startDocument() throws IOException {
        ResponseWriter writer = this.getWrapped();
        String encoding = writer.getCharacterEncoding();
        if (encoding == null) {
            encoding = "utf-8";
        }
        writer.write("<?xml version='1.0' encoding='" + encoding + "'?>\n");
        writer.startElement("partial-response", null);
    }

    @Override
    public void endDocument() throws IOException {
        this.endChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.endElement("partial-response");
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertBefore = true;
        ResponseWriter writer = this.getWrapped();
        writer.startElement("insert", null);
        writer.startElement("before", null);
        writer.writeAttribute("id", targetId, null);
        writer.startCDATA();
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertAfter = true;
        ResponseWriter writer = this.getWrapped();
        writer.startElement("insert", null);
        writer.startElement("after", null);
        writer.writeAttribute("id", targetId, null);
        writer.startCDATA();
    }

    public void endInsert() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        if (this.inInsertBefore) {
            writer.endElement("before");
            this.inInsertBefore = false;
        } else if (this.inInsertAfter) {
            writer.endElement("after");
            this.inInsertAfter = false;
        }
        writer.endElement("insert");
    }

    public void startUpdate(String targetId) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("update", null);
        writer.writeAttribute("id", targetId, null);
        writer.startCDATA();
    }

    public void endUpdate() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        writer.endElement("update");
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("attributes", null);
        writer.writeAttribute("id", targetId, null);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            writer.startElement("attribute", null);
            writer.writeAttribute("name", entry.getKey(), null);
            writer.writeAttribute("value", entry.getValue(), null);
            writer.endElement("attribute");
        }
        writer.endElement("attributes");
    }

    public void delete(String targetId) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("delete", null);
        writer.writeAttribute("id", targetId, null);
        writer.endElement("delete");
    }

    public void redirect(String url) throws IOException {
        this.endChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("redirect", null);
        writer.writeAttribute("url", url, null);
        writer.endElement("redirect");
    }

    public void startEval() throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("eval", null);
        writer.startCDATA();
    }

    public void endEval() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        writer.endElement("eval");
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("extension", null);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                writer.writeAttribute(entry.getKey(), entry.getValue(), null);
            }
        }
    }

    public void endExtension() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endElement("extension");
    }

    public void startError(String errorName) throws IOException {
        this.endChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("error", null);
        writer.startElement("error-name", null);
        writer.write(errorName);
        writer.endElement("error-name");
        writer.startElement("error-message", null);
        writer.startCDATA();
    }

    public void endError() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        writer.endElement("error-message");
        writer.endElement("error");
    }

    private void startChangesIfNecessary() throws IOException {
        if (!this.inChanges) {
            ResponseWriter writer = this.getWrapped();
            writer.startElement("changes", null);
            this.inChanges = true;
        }
    }

    private void endChangesIfNecessary() throws IOException {
        if (this.inChanges) {
            ResponseWriter writer = this.getWrapped();
            writer.endElement("changes");
            this.inChanges = false;
        }
    }
}

