/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.persistence.jpa.jpql.AbsFunctionResolver;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ClassNameResolver;
import org.eclipse.persistence.jpa.jpql.ClassResolver;
import org.eclipse.persistence.jpa.jpql.CollectionEquivalentResolver;
import org.eclipse.persistence.jpa.jpql.CollectionValuedFieldResolver;
import org.eclipse.persistence.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.jpql.EntityResolver;
import org.eclipse.persistence.jpa.jpql.EnumLiteralResolver;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.KeyResolver;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.NullResolver;
import org.eclipse.persistence.jpa.jpql.NumericResolver;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.SumFunctionResolver;
import org.eclipse.persistence.jpa.jpql.TreatResolver;
import org.eclipse.persistence.jpa.jpql.ValueResolver;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.spi.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResolverBuilder
implements ExpressionVisitor {
    private CollectionExpressionVisitor collectionExpressionVisitor;
    private final JPQLQueryContext queryContext;
    protected Resolver resolver;
    public static Pattern DOUBLE_REGEXP = Pattern.compile("^[-+]?[0-9]*(\\.[0-9]+)?([dD]|([eE][-+]?[0-9]+))?$");
    public static Pattern FLOAT_REGEXP = Pattern.compile("^[-+]?[0-9]*(\\.[0-9]+)?[fF]$");
    public static Pattern INTEGER_REGEXP = Pattern.compile("^[-+]?[0-9]+$");
    public static Pattern LONG_REGEXP = Pattern.compile("^[-+]?[0-9]+[lL]?$");

    public ResolverBuilder(JPQLQueryContext queryContext) {
        Assert.isNotNull(queryContext, "The JPQLQueryContext cannot be null");
        this.queryContext = queryContext;
    }

    protected Resolver buildClassNameResolver(String typeName) {
        return new ClassNameResolver(this.getDeclarationResolver(), typeName);
    }

    protected Resolver buildClassResolver(Class<?> type) {
        return new ClassResolver(this.getDeclarationResolver(), type);
    }

    protected CollectionExpressionVisitor buildCollectionExpressionVisitor() {
        return new CollectionExpressionVisitor();
    }

    protected Resolver buildCollectionValuedFieldResolver(String variableName) {
        Resolver resolver = this.resolver.getChild(variableName);
        if (resolver == null) {
            resolver = new CollectionValuedFieldResolver(this.resolver, variableName);
        }
        return resolver;
    }

    protected Resolver buildEnumResolver(AbstractPathExpression expression, IType type, String enumLiteral) {
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        return new EnumLiteralResolver(parent, type, enumLiteral);
    }

    protected Resolver buildNullResolver() {
        return new NullResolver(this.getDeclarationResolver());
    }

    protected Resolver buildStateFieldResolver(String variableName) {
        Resolver resolver = this.resolver.getChild(variableName);
        if (resolver == null) {
            resolver = new StateFieldResolver(this.resolver, variableName);
        }
        return resolver;
    }

    protected CollectionExpression getCollectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.getCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected CollectionExpressionVisitor getCollectionExpressionVisitor() {
        if (this.collectionExpressionVisitor == null) {
            this.collectionExpressionVisitor = this.buildCollectionExpressionVisitor();
        }
        return this.collectionExpressionVisitor;
    }

    protected DeclarationResolver getDeclarationResolver() {
        return this.queryContext.getDeclarationResolver();
    }

    protected DeclarationResolver getDeclarationResolver(Expression expression) {
        return this.queryContext.getDeclarationResolver(expression);
    }

    protected JPQLQueryContext getQueryContext() {
        return this.queryContext;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void visit(AbsExpression expression) {
        expression.getExpression().accept(this);
        this.resolver = new AbsFunctionResolver(this.resolver);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        String abstractSchemaName = expression.getText();
        if (ExpressionTools.stringIsNotEmpty(abstractSchemaName)) {
            DeclarationResolver parent = this.getDeclarationResolver(expression);
            this.resolver = new EntityResolver(parent, abstractSchemaName);
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(AdditionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(AndExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        expression.getExpression().accept(this);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, this.resolver);
    }

    @Override
    public void visit(AvgFunction expression) {
        this.resolver = this.buildClassResolver(Double.class);
    }

    @Override
    public void visit(BadExpression expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(BetweenExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(CaseExpression expression) {
        this.visitCollectionEquivalentExpression(expression.getWhenClauses(), expression.getElseExpression());
    }

    @Override
    public void visit(CoalesceExpression expression) {
        this.visitCollectionEquivalentExpression(expression.getExpression(), null);
    }

    @Override
    public void visit(CollectionExpression expression) {
        expression.acceptChildren(this);
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        expression.getCollectionValuedPathExpression().accept(this);
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        if (!expression.endsWithDot()) {
            String path = expression.toActualText();
            IType type = this.queryContext.getTypeRepository().getEnumType(path);
            if (type != null) {
                this.resolver = this.buildEnumResolver(expression, type, path);
            } else {
                expression.getIdentificationVariable().accept(this);
                int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
                int count = expression.pathSize();
                while (index < count) {
                    path = expression.getPath(index);
                    this.resolver = index + 1 < count ? this.buildStateFieldResolver(path) : this.buildCollectionValuedFieldResolver(path);
                    ++index;
                }
            }
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(ComparisonExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(ConcatExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(ConstructorExpression expression) {
        String className = expression.getClassName();
        this.resolver = ExpressionTools.stringIsNotEmpty(className) ? this.buildClassNameResolver(className) : this.buildNullResolver();
    }

    @Override
    public void visit(CountFunction expression) {
        this.resolver = this.buildClassResolver(Long.class);
    }

    @Override
    public void visit(DateTime expression) {
        String text;
        this.resolver = expression.isCurrentDate() ? this.buildClassResolver(Date.class) : (expression.isCurrentTime() ? this.buildClassResolver(Time.class) : (expression.isCurrentTimestamp() ? this.buildClassResolver(Timestamp.class) : ((text = expression.getText()).startsWith("{d") ? this.buildClassResolver(Date.class) : (text.startsWith("{ts") ? this.buildClassResolver(Timestamp.class) : (text.startsWith("{t") ? this.buildClassResolver(Time.class) : this.buildNullResolver())))));
    }

    @Override
    public void visit(DeleteClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(DeleteStatement expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(DivisionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        String entityTypeName = expression.getEntityTypeName();
        if (ExpressionTools.stringIsNotEmpty(entityTypeName)) {
            DeclarationResolver parent = this.getDeclarationResolver(expression);
            this.resolver = new EntityResolver(parent, entityTypeName);
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(EntryExpression expression) {
        this.resolver = this.buildClassResolver(Map.Entry.class);
    }

    @Override
    public void visit(ExistsExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(FromClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(FunctionExpression expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(GroupByClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(HavingClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = parent.getResolver(expression.getVariableName());
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(IndexExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(InExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(InputParameter expression) {
        this.resolver = this.buildClassNameResolver("UNRESOLVABLE_TYPE");
    }

    @Override
    public void visit(Join expression) {
        expression.getJoinAssociationPath().accept(this);
        this.resolver.setNullAllowed(expression.isLeftJoin());
    }

    @Override
    public void visit(JPQLExpression expression) {
        expression.getQueryStatement().accept(this);
    }

    @Override
    public void visit(KeyExpression expression) {
        expression.getExpression().accept(this);
        this.resolver = new KeyResolver(this.resolver);
    }

    @Override
    public void visit(KeywordExpression expression) {
        String text = expression.getText();
        this.resolver = text == "FALSE" || text == "TRUE" ? this.buildClassResolver(Boolean.class) : this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(LengthExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(LikeExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(LocateExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(LowerExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(MaxFunction expression) {
        expression.getExpression().accept(this);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, this.resolver);
    }

    @Override
    public void visit(MinFunction expression) {
        expression.getExpression().accept(this);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, this.resolver);
    }

    @Override
    public void visit(ModExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(NullExpression expression) {
        this.resolver = this.buildClassNameResolver("UNRESOLVABLE_TYPE");
    }

    @Override
    public void visit(NullIfExpression expression) {
        expression.getFirstExpression().accept(this);
    }

    @Override
    public void visit(NumericLiteral expression) {
        try {
            String text = expression.getText();
            if (LONG_REGEXP.matcher(text).matches() || INTEGER_REGEXP.matcher(text).matches()) {
                Long value = Long.parseLong(text);
                this.resolver = value <= Integer.MAX_VALUE ? this.buildClassResolver(Integer.class) : this.buildClassResolver(Long.class);
            } else if (FLOAT_REGEXP.matcher(text).matches()) {
                this.resolver = this.buildClassResolver(Float.class);
            } else if (DOUBLE_REGEXP.matcher(text).matches()) {
                this.resolver = this.buildClassResolver(Double.class);
            }
        }
        catch (Exception exception) {
            this.resolver = this.buildClassResolver(Object.class);
        }
    }

    @Override
    public void visit(ObjectExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(OnClause expression) {
        expression.getConditionalExpression().accept(this);
    }

    @Override
    public void visit(OrderByClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(OrderByItem expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(OrExpression expression) {
        this.resolver = this.buildClassResolver(Boolean.class);
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept(this);
    }

    @Override
    public void visit(SelectClause expression) {
        Expression selectExpression = expression.getSelectExpression();
        CollectionExpression collectionExpression = this.getCollectionExpression(selectExpression);
        if (collectionExpression != null) {
            this.resolver = this.buildClassResolver(Object[].class);
        } else {
            selectExpression.accept(this);
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        expression.getSelectClause().accept(this);
    }

    @Override
    public void visit(SimpleFromClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        expression.getSelectExpression().accept(this);
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        this.queryContext.newSubqueryContext(expression);
        try {
            expression.getSelectClause().accept(this);
        }
        finally {
            this.queryContext.disposeSubqueryContext();
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        this.resolver = this.buildClassResolver(Integer.class);
    }

    @Override
    public void visit(SqrtExpression expression) {
        this.resolver = this.buildClassResolver(Double.class);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        if (!expression.endsWithDot()) {
            String path = expression.toActualText();
            IType type = this.queryContext.getTypeRepository().getEnumType(path);
            if (type != null) {
                this.resolver = this.buildEnumResolver(expression, type, path);
            } else {
                expression.getIdentificationVariable().accept(this);
                int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
                int count = expression.pathSize();
                while (index < count) {
                    path = expression.getPath(index);
                    this.resolver = this.buildStateFieldResolver(expression.getPath(index));
                    ++index;
                }
            }
        } else {
            this.resolver = this.buildNullResolver();
        }
    }

    @Override
    public void visit(StringLiteral expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(SubExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(SubstringExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(SubtractionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        expression.getExpression().accept(this);
        this.resolver = new SumFunctionResolver(this.resolver);
    }

    @Override
    public void visit(TreatExpression expression) {
        expression.getCollectionValuedPathExpression().accept(this);
        String entityTypeName = this.getQueryContext().literal(expression.getEntityType(), LiteralType.ENTITY_TYPE);
        this.resolver = new TreatResolver(this.resolver, entityTypeName);
    }

    @Override
    public void visit(TrimExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(TypeExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(UnknownExpression expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpdateClause expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpdateItem expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpdateStatement expression) {
        this.resolver = this.buildClassResolver(Object.class);
    }

    @Override
    public void visit(UpperExpression expression) {
        this.resolver = this.buildClassResolver(String.class);
    }

    @Override
    public void visit(ValueExpression expression) {
        expression.getExpression().accept(this);
        this.resolver = new ValueResolver(this.resolver);
    }

    @Override
    public void visit(WhenClause expression) {
        expression.getThenExpression().accept(this);
    }

    @Override
    public void visit(WhereClause expression) {
        expression.getConditionalExpression().accept(this);
    }

    protected void visitArithmeticExpression(ArithmeticExpression expression) {
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>(2);
        expression.getLeftExpression().accept(this);
        resolvers.add(this.resolver);
        expression.getRightExpression().accept(this);
        resolvers.add(this.resolver);
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new NumericResolver((Resolver)parent, resolvers);
    }

    protected void visitCollectionEquivalentExpression(Expression expression, Expression extraExpression) {
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>();
        CollectionExpression collectionExpression = this.getCollectionExpression(expression);
        if (collectionExpression != null) {
            for (Expression child : collectionExpression.children()) {
                child.accept(this);
                resolvers.add(this.resolver);
            }
        } else {
            expression.accept(this);
            resolvers.add(this.resolver);
        }
        if (extraExpression != null) {
            extraExpression.accept(this);
            resolvers.add(this.resolver);
        }
        DeclarationResolver parent = this.getDeclarationResolver(expression);
        this.resolver = new CollectionEquivalentResolver(parent, resolvers);
    }

    protected static final class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionExpression expression;

        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }
}

