/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.util.iterator;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.ArrayIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.Mutator;
import org.eclipse.persistence.jpa.jpql.util.iterator.NullMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneIterator<E>
implements IterableIterator<E> {
    private E current;
    private Mutator<E> mutator;
    private Iterator<E> nestedIterator;
    private static final Object UNKNOWN = new Object();

    public CloneIterator(Collection<? extends E> collection) {
        this(collection, NullMutator.instance());
    }

    public CloneIterator(Collection<? extends E> collection, Mutator<? extends E> mutator) {
        this.nestedIterator = new ArrayIterator(collection.toArray());
        this.mutator = mutator;
        this.current = UNKNOWN;
    }

    @Override
    public boolean hasNext() {
        return this.nestedIterator.hasNext();
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public E next() {
        this.current = this.nestedIterator.next();
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == UNKNOWN) {
            throw new IllegalStateException("No more item can be removed.");
        }
        this.remove(this.current);
        this.current = UNKNOWN;
    }

    protected void remove(E item) {
        this.mutator.remove(item);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

