/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic.enricher;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.ObserverAdded;

public class AdditionalLibClassLoaderEnricherObserver {
    public static final String OPENEJB_ENRICHER_ADDITIONAL_LIB = "openejb.enricher.additional-lib";
    private static boolean initDone = false;
    private String path = "additional-lib";

    public void initEnricher(@Observes ObserverAdded event) {
        File[] libs;
        String systProp;
        if (initDone || this.path == null || !AdditionalLibClassLoaderEnricherObserver.class.isInstance(event.getObserver())) {
            return;
        }
        File dir = new File(this.path);
        if (!dir.exists() && (systProp = SystemInstance.get().getProperty(OPENEJB_ENRICHER_ADDITIONAL_LIB, (String)null)) != null) {
            dir = new File(systProp);
        }
        if (dir.exists() && (libs = dir.listFiles()) != null) {
            ClassLoaderEnricher enricher = (ClassLoaderEnricher)SystemInstance.get().getComponent(ClassLoaderEnricher.class);
            for (File lib : libs) {
                try {
                    enricher.addUrl(lib.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new OpenEJBRuntimeException(e);
                }
            }
        }
        initDone = true;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

