/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

public final class ArtifactSpecification {
    private static final Map<String, String> IMMUTABLE_EMPTY_MAP = Collections.emptyMap();
    private final String type;
    private final String name;
    private final VersionRange versionRange;
    private final URI uri;
    private final Map<String, String> properties;

    public ArtifactSpecification(@NonNull String type, @NonNull String name, @NonNull VersionRange versionRange) {
        this(type, name, versionRange, null, null);
    }

    public ArtifactSpecification(@NonNull String type, @NonNull String name, @NonNull VersionRange versionRange, @NonNull Map<String, String> properties) {
        this(type, name, versionRange, null, properties);
    }

    public ArtifactSpecification(@NonNull URI uri) {
        this(null, null, null, uri, null);
    }

    public ArtifactSpecification(@NonNull URI uri, @NonNull Map<String, String> properties) {
        this(null, null, null, uri, properties);
    }

    private ArtifactSpecification(String type, String name, VersionRange versionRange, URI uri, Map<String, String> properties) {
        this.type = type;
        this.name = name;
        this.versionRange = versionRange;
        this.uri = uri;
        this.properties = properties == null ? IMMUTABLE_EMPTY_MAP : Collections.unmodifiableMap(properties);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

