/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleInfosUpdater {
    private static final String UNKNOWN = "unknown";
    private static File bundlesInfoFile;
    private static File baseDir;
    private static HashMap<String, BundleInfo> toBeAddedInBundlesInfo;
    private static HashMap<String, BundleInfo> toBeRemovedFromBundlesInfo;

    public BundleInfosUpdater(URL bundlesInfoURL, File base) {
        bundlesInfoFile = new File(bundlesInfoURL.getFile());
        toBeAddedInBundlesInfo = new HashMap();
        toBeRemovedFromBundlesInfo = new HashMap();
        baseDir = base;
    }

    public BundleInfosUpdater(File bundlesInfo, File base) {
        bundlesInfoFile = bundlesInfo;
        toBeAddedInBundlesInfo = new HashMap();
        toBeRemovedFromBundlesInfo = new HashMap();
        baseDir = base;
    }

    public static void registerToBundlesInfo(Bundle bundle, String stagedRelativeLocation, boolean isFragment) throws URISyntaxException, IOException, BundleException {
        String symbolicName = bundle.getSymbolicName();
        BundleInfosUpdater.addBundleToBundlesInfo(symbolicName == null ? UNKNOWN : symbolicName, new URI(stagedRelativeLocation), bundle.getVersion().toString(), 5, !isFragment);
        BundleInfosUpdater.updateBundleInfosRepository();
    }

    public static void unregisterToBundlesInfo(Bundle bundle, String stagedRelativeLocation, boolean isFragment) throws IOException, BundleException, URISyntaxException {
        String symbolicName = bundle.getSymbolicName();
        BundleInfosUpdater.removeBundleFromBundlesInfo(symbolicName == null ? UNKNOWN : symbolicName, new URI(stagedRelativeLocation), bundle.getVersion().toString(), 5, !isFragment);
        BundleInfosUpdater.updateBundleInfosRepository();
    }

    public void addBundlesToBundlesInfo(File[] files) throws IOException, BundleException {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File currFile = fileArray[n2];
            BundleInfo currBundleInfo = BundleInfosUpdater.bundleFile2BundleInfo(currFile, 4, true);
            if (currBundleInfo != null) {
                toBeAddedInBundlesInfo.put(BundleInfosUpdater.getIdentifier(currBundleInfo), currBundleInfo);
            }
            ++n2;
        }
    }

    private static String getIdentifier(BundleInfo bundleInfo) {
        return String.valueOf(bundleInfo.getSymbolicName()) + "=" + bundleInfo.getVersion();
    }

    public void addBundleToBundlesInfo(File file, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        BundleInfo bundleInfo = BundleInfosUpdater.bundleFile2BundleInfo(file, startLevel, autoStartFlag);
        if (bundleInfo != null) {
            toBeAddedInBundlesInfo.put(BundleInfosUpdater.getIdentifier(bundleInfo), bundleInfo);
        }
    }

    private static void addBundleToBundlesInfo(String bundleSymbolicName, URI url, String bundleVersion, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        try {
            BundleInfo bundleInfo = BundleInfosUpdater.createBundleInfo(bundleSymbolicName, bundleVersion, url, startLevel, autoStartFlag);
            if (bundleInfo != null) {
                toBeAddedInBundlesInfo.put(BundleInfosUpdater.getIdentifier(bundleInfo), bundleInfo);
            }
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getCause());
        }
    }

    private static void removeBundleFromBundlesInfo(String bundleSymbolicName, URI url, String bundleVersion, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        try {
            BundleInfo bundleInfo = BundleInfosUpdater.createBundleInfo(bundleSymbolicName, bundleVersion, url, startLevel, autoStartFlag);
            if (bundleInfo != null) {
                toBeRemovedFromBundlesInfo.put(BundleInfosUpdater.getIdentifier(bundleInfo), bundleInfo);
            }
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getCause());
        }
    }

    public boolean isAvailable() {
        return bundlesInfoFile.exists();
    }

    private static HashMap<String, BundleInfo> readBundleInfosInMap(List<BundleInfo> bundleInfos) {
        HashMap<String, BundleInfo> infos = new HashMap<String, BundleInfo>();
        for (BundleInfo bundleInfo : bundleInfos) {
            infos.put(BundleInfosUpdater.getIdentifier(bundleInfo), bundleInfo);
        }
        return infos;
    }

    private static void updateBundleInfosRepository() throws IOException {
        List readConfiguration = SimpleConfiguratorUtils.readConfiguration((URL)bundlesInfoFile.toURI().toURL(), (URI)(baseDir == null ? null : baseDir.toURI()));
        HashMap<String, BundleInfo> currentBundleInfos = BundleInfosUpdater.readBundleInfosInMap(readConfiguration);
        currentBundleInfos.putAll(toBeAddedInBundlesInfo);
        toBeAddedInBundlesInfo.clear();
        for (String identifier : toBeRemovedFromBundlesInfo.keySet()) {
            currentBundleInfos.remove(identifier);
        }
        toBeRemovedFromBundlesInfo.clear();
        if (bundlesInfoFile.exists()) {
            String backupName = String.valueOf(bundlesInfoFile.getName()) + System.currentTimeMillis();
            File backupFile = new File(bundlesInfoFile.getParentFile(), backupName);
            if (!bundlesInfoFile.renameTo(backupFile)) {
                throw new IOException("Fail to rename from (" + bundlesInfoFile + ") to (" + backupFile + ")");
            }
        }
        SimpleConfiguratorManipulatorUtils.writeConfiguration((BundleInfo[])currentBundleInfos.values().toArray(new BundleInfo[currentBundleInfos.size()]), (File)bundlesInfoFile);
    }

    private static BundleInfo bundleFile2BundleInfo(File file, int startLevel, boolean autoStartFlag) throws IOException, BundleException {
        try {
            Attributes mainAttributes;
            String symbName;
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (symbName = (mainAttributes = manifest.getMainAttributes()).getValue("Bundle-SymbolicName")) != null) {
                ManifestElement[] symbNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbName);
                return BundleInfosUpdater.createBundleInfo(symbNameHeader[0].getValue(), mainAttributes.getValue("Bundle-Version"), file.toURI(), startLevel, autoStartFlag);
            }
            return null;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getCause());
        }
    }

    private static BundleInfo createBundleInfo(String symbName, String bundleVersion, URI uri, int startLevel, boolean autoStart) throws URISyntaxException {
        return new BundleInfo(symbName, bundleVersion, uri, startLevel, autoStart);
    }
}

