/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Container;
import org.apache.openejb.Injection;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanBuilder;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.InterceptorBindingBuilder;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.MethodScheduleBuilder;
import org.apache.openejb.util.Messages;

public class EjbJarBuilder {
    protected static final Messages messages = new Messages("org.apache.openejb.util.resources");
    private final Properties props;
    private AppContext context;

    public EjbJarBuilder(Properties props, AppContext context) {
        this.props = props;
        this.context = context;
    }

    public HashMap<String, BeanContext> build(EjbJarInfo ejbJar, Collection<Injection> appInjections, ClassLoader classLoader) throws OpenEJBException {
        InjectionBuilder injectionBuilder = new InjectionBuilder(classLoader);
        List<Injection> moduleInjections = injectionBuilder.buildInjections(ejbJar.moduleJndiEnc);
        moduleInjections.addAll(appInjections);
        Context moduleJndiContext = new JndiEncBuilder(ejbJar.moduleJndiEnc, moduleInjections, null, ejbJar.moduleName, ejbJar.moduleUri, ejbJar.uniqueId, classLoader).build(JndiEncBuilder.JndiScope.module);
        HashMap<String, BeanContext> deployments = new HashMap<String, BeanContext>();
        ModuleContext moduleContext = new ModuleContext(ejbJar.moduleName, ejbJar.moduleUri, ejbJar.uniqueId, this.context, moduleJndiContext, classLoader);
        moduleContext.getProperties().putAll((Map<?, ?>)ejbJar.properties);
        InterceptorBindingBuilder interceptorBindingBuilder = new InterceptorBindingBuilder(classLoader, ejbJar);
        MethodScheduleBuilder methodScheduleBuilder = new MethodScheduleBuilder();
        for (EnterpriseBeanInfo ejbInfo : ejbJar.enterpriseBeans) {
            try {
                EnterpriseBeanBuilder deploymentBuilder = new EnterpriseBeanBuilder(ejbInfo, moduleContext, moduleInjections);
                BeanContext bean = deploymentBuilder.build();
                interceptorBindingBuilder.build(bean, ejbInfo);
                methodScheduleBuilder.build(bean, ejbInfo);
                deployments.put(ejbInfo.ejbDeploymentId, bean);
                Container container = (Container)this.props.get(ejbInfo.containerId);
                if (container == null) {
                    throw new IllegalStateException("Container does not exist: " + ejbInfo.containerId + ".  Referenced by deployment: " + bean.getDeploymentID());
                }
                bean.setContainer(container);
            }
            catch (Throwable e) {
                throw new OpenEJBException("Error building bean '" + ejbInfo.ejbName + "'.  Exception: " + e.getClass() + ": " + e.getMessage(), e);
            }
        }
        return deployments;
    }
}

