/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.ApplicationClient;

public class GeneratedClientModules {

    public static class Add
    implements DynamicDeployer {
        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                if (ejbModule.getClientModule() == null) continue;
                appModule.getClientModules().add(ejbModule.getClientModule());
                ejbModule.setClientModule(null);
            }
            return appModule;
        }
    }

    public static class Prune
    implements DynamicDeployer {
        @Override
        public AppModule deploy(AppModule appModule) throws OpenEJBException {
            ArrayList<ClientModule> clientModules = new ArrayList<ClientModule>(appModule.getClientModules());
            for (ClientModule clientModule : clientModules) {
                boolean haveAnnotatedClients;
                boolean haveMainClassAndDescriptor = clientModule.getMainClass() != null && clientModule.getApplicationClient() != null;
                boolean bl = haveAnnotatedClients = clientModule.getLocalClients().size() > 0 || clientModule.getRemoteClients().size() > 0;
                if (clientModule.isEjbModuleGenerated() && !haveMainClassAndDescriptor && !haveAnnotatedClients) {
                    appModule.getClientModules().remove(clientModule);
                    continue;
                }
                if (clientModule.getApplicationClient() != null) continue;
                clientModule.setApplicationClient(new ApplicationClient());
            }
            return appModule;
        }
    }
}

