/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.common.StringUtils;
import org.osgi.framework.Bundle;

public class SpringUtils {
    private static final String SPRING_DM_CONTEXT_DIR = "/META-INF/spring/";
    private static final String BLUEPRINT_CONTEXT_DIR = "/OSGI-INF/blueprint/";
    private static final String CONTEXT_FILES = "*.xml";
    private static final String BUNDLE_URL_PREFIX = "osgibundle:";
    private static final String SPRING_CONTEXT_HEADER = "Spring-Context";
    private static final String BUNDLE_BLUEPRINT_HEADER = "Bundle-Blueprint";
    private static final String DIRECTIVE_SEPARATOR = ";";
    private static final String CONTEXT_LOCATION_SEPARATOR = ",";
    private static final String CONFIG_WILDCARD = "*";
    private static final String SPRING_DM_DEFAULT_CONFIG = "osgibundle:/META-INF/spring/*.xml";
    private static final String BLUEPRINT_DEFAULT_CONFIG = "osgibundle:/OSGI-INF/blueprint/*.xml";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public SpringUtils() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String[] getSpringContextConfigurations(Bundle bundle) {
        try {
            Object[] locations = SpringUtils.getSpringContextHeaderLocations(bundle.getHeaders());
            if (SpringUtils.isArrayEmpty(locations)) {
                Enumeration defaultConfig = bundle.findEntries(SPRING_DM_CONTEXT_DIR, CONTEXT_FILES, false);
                if (defaultConfig != null && defaultConfig.hasMoreElements()) {
                    return new String[]{SPRING_DM_DEFAULT_CONFIG};
                }
                defaultConfig = bundle.findEntries(BLUEPRINT_CONTEXT_DIR, CONTEXT_FILES, false);
                if (defaultConfig != null && defaultConfig.hasMoreElements()) {
                    return new String[]{BLUEPRINT_DEFAULT_CONFIG};
                }
                return new String[0];
            }
            return locations;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static String[] getSpringContextHeaderLocations(Dictionary headers) {
        try {
            String[] ctxEntries;
            String header = SpringUtils.getSpringContextHeader(headers);
            if (StringUtils.hasText((String)header) && ';' != header.charAt(0)) {
                String locations = StringUtils.tokenizeToStringArray((String)header, (String)DIRECTIVE_SEPARATOR)[0];
                ctxEntries = StringUtils.tokenizeToStringArray((String)locations, (String)CONTEXT_LOCATION_SEPARATOR);
                int i = 0;
                while (i < ctxEntries.length) {
                    if (CONFIG_WILDCARD.equals(ctxEntries[i])) {
                        ctxEntries[i] = SPRING_DM_DEFAULT_CONFIG;
                    }
                    ++i;
                }
            } else {
                header = SpringUtils.getBundleBlueprintHeader(headers);
                if (StringUtils.hasText((String)header) && ';' != header.charAt(0)) {
                    String locations = StringUtils.tokenizeToStringArray((String)header, (String)DIRECTIVE_SEPARATOR)[0];
                    ctxEntries = StringUtils.tokenizeToStringArray((String)locations, (String)CONTEXT_LOCATION_SEPARATOR);
                    int i = 0;
                    while (i < ctxEntries.length) {
                        if (CONFIG_WILDCARD.equals(ctxEntries[i])) {
                            ctxEntries[i] = BLUEPRINT_DEFAULT_CONFIG;
                        }
                        ++i;
                    }
                } else {
                    ctxEntries = new String[]{};
                }
            }
            return ctxEntries;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static boolean isArrayEmpty(Object[] array) {
        try {
            boolean bl;
            SpringUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                bl = array == null || array.length == 0;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            SpringUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return bl;
        }
        catch (Throwable throwable) {
            SpringUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    static String getSpringContextHeader(Dictionary headers) {
        try {
            Object header = null;
            if (headers != null) {
                header = headers.get(SPRING_CONTEXT_HEADER);
            }
            return header != null ? header.toString().trim() : null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static String getBundleBlueprintHeader(Dictionary headers) {
        try {
            Object header = null;
            if (headers != null) {
                header = headers.get(BUNDLE_BLUEPRINT_HEADER);
            }
            return header != null ? header.toString().trim() : null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static boolean isSpringDMPoweredBundle(Bundle bundle) {
        try {
            boolean bl;
            SpringUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                Object[] configurations = SpringUtils.getSpringContextConfigurations(bundle);
                bl = !SpringUtils.isArrayEmpty(configurations);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            SpringUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return bl;
        }
        catch (Throwable throwable) {
            SpringUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("SpringUtils.java", Class.forName("org.eclipse.virgo.nano.core.internal.SpringUtils"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "isArrayEmpty", "org.eclipse.virgo.nano.core.internal.SpringUtils", "[Ljava.lang.Object;:", "array:", "", "boolean"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isSpringDMPoweredBundle", "org.eclipse.virgo.nano.core.internal.SpringUtils", "org.osgi.framework.Bundle:", "bundle:", "", "boolean"), 128);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.core.internal.SpringUtils");
    }
}

