/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.osgicommand.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.service.command.Descriptor;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.shell.osgicommand.helper.ClassLoadingHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GogoClassLoadingCommand {
    private BundleContext bundleContext;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public GogoClassLoadingCommand(BundleContext context) {
        this.bundleContext = context;
    }

    @Descriptor(value="list all bundles that contain a class or resource with the specified name")
    public void clhas(@Descriptor(value="class or resource name") String className) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            className = ClassLoadingHelper.convertToResourcePath(className);
            Map<Bundle, List<String>> foundBundles = ClassLoadingHelper.getBundlesContainingResource(this.bundleContext, className);
            if (foundBundles.size() == 0) {
                System.out.println("No bundle contains [" + className + "]");
            } else {
                this.outputBundlesAndResources("Bundles containing [" + className + "]:", foundBundles);
            }
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Descriptor(value="list all bundles that can load the specified class")
    public void clload(@Descriptor(value="fully qualified class name") String className) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            this.doClload(className, null);
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    @Descriptor(value="try to load the specified class using the specified bundle")
    public void clload(@Descriptor(value="fully qualified class name") String className, @Descriptor(value="bundle symbolic name") String bundleName) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            this.doClload(className, bundleName);
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    @Descriptor(value="try to load the specified class using the specified bundle")
    public void clload(@Descriptor(value="fully qualified class name") String className, @Descriptor(value="  bundle id") long bundleId) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            this.doClload(className, String.valueOf(bundleId));
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void doClload(String className, String bundle) {
        try {
            Map<Bundle, Bundle> foundBundles;
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            if (this.extractPackage(className) == null) {
                System.out.println("Warning: the class name [" + className + "] has no package and is assumed to belong to the default package");
            }
            if ((foundBundles = bundle == null ? ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className) : ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className, bundle)).size() == 0) {
                if (bundle == null) {
                    System.out.println("No bundle can load class [" + className + "]");
                } else {
                    System.out.println("Bundle [" + bundle + "] cannot load class [" + className + "]");
                }
            } else {
                this.outputFoundBundlesAndRelations("Successfully loaded [" + className + "] " + (bundle != null ? "using class loader from:" : "from:"), foundBundles, "provided by");
            }
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    @Descriptor(value="list all bundles that export a class with the specified name")
    public void clexport(@Descriptor(value="fully qualified class name") String className) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            String classPackage = this.extractPackage(className);
            if (classPackage == null) {
                System.out.println("The class name [" + className + "] contains no package");
            } else {
                Bundle[] bundles = this.bundleContext.getBundles();
                HashMap<Long, String> foundBundles = new HashMap<Long, String>();
                Bundle[] bundleArray = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    if (ClassLoadingHelper.isPackageExported(this.bundleContext, classPackage, bundle)) {
                        if (ClassLoadingHelper.tryToLoadClass(className, bundle) != null) {
                            foundBundles.put(bundle.getBundleId(), bundle.getSymbolicName());
                        } else {
                            foundBundles.put(bundle.getBundleId(), String.valueOf(bundle.getSymbolicName()) + "     [class not found, package only]");
                        }
                    }
                    ++n2;
                }
                if (foundBundles.size() == 0) {
                    System.out.println("No bundle exports class [" + className + "]");
                } else {
                    System.out.println();
                    System.out.println("Bundles exporting [" + className + "]:");
                    for (Map.Entry entry : foundBundles.entrySet()) {
                        System.out.println("  " + entry.getKey() + "\t" + (String)entry.getValue());
                    }
                }
            }
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private String extractPackage(String className) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            int index = className.lastIndexOf(".");
            String string = index == -1 ? null : className.substring(0, index);
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return string;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private void outputFoundBundlesAndRelations(String message, Map<Bundle, Bundle> foundBundles, String relation) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            System.out.println();
            System.out.println(message);
            for (Map.Entry<Bundle, Bundle> entry : foundBundles.entrySet()) {
                Bundle originalBundle;
                Bundle testBundle = entry.getKey();
                if (testBundle.equals(originalBundle = entry.getValue())) {
                    System.out.println("  " + this.bundleToString(testBundle, false));
                    continue;
                }
                System.out.println("  " + this.bundleToString(testBundle, false));
                if (relation == null) continue;
                System.out.println("  \t\t[" + relation + " " + this.bundleToString(originalBundle, true) + "]");
            }
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private void outputBundlesAndResources(String message, Map<Bundle, List<String>> foundBundles) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            System.out.println();
            System.out.println(message);
            for (Map.Entry<Bundle, List<String>> bundleListEntry : foundBundles.entrySet()) {
                System.out.println("  " + this.bundleToString(bundleListEntry.getKey(), false));
                for (String resource : bundleListEntry.getValue()) {
                    System.out.println("  \t\t" + resource);
                }
            }
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private String bundleToString(Bundle b, boolean space) {
        try {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
            String string = String.valueOf(b.getBundleId()) + (space ? " " : "\t") + b.getSymbolicName();
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
            return string;
        }
        catch (Throwable throwable) {
            GogoClassLoadingCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("GogoClassLoadingCommand.java", Class.forName("org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clhas", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:", "className:", "", "void"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clload", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:", "className:", "", "void"), 54);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clload", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:java.lang.String:", "className:bundleName:", "", "void"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clload", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:long:", "className:bundleId:", "", "void"), 64);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doClload", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:java.lang.String:", "className:bundle:", "", "void"), 68);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clexport", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:", "className:", "", "void"), 98);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractPackage", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:", "className:", "", "java.lang.String"), 130);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "outputFoundBundlesAndRelations", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:java.util.Map:java.lang.String:", "message:foundBundles:relation:", "", "void"), 142);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "outputBundlesAndResources", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "java.lang.String:java.util.Map:", "message:foundBundles:", "", "void"), 165);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "bundleToString", "org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand", "org.osgi.framework.Bundle:boolean:", "b:space:", "", "java.lang.String"), 185);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand");
    }
}

