/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.Method;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.util.ReflectionUtils;

public abstract class QuartzJobBean
implements Job {
    private static final Method getSchedulerMethod;
    private static final Method getMergedJobDataMapMethod;

    static {
        try {
            getSchedulerMethod = JobExecutionContext.class.getMethod("getScheduler", new Class[0]);
            getMergedJobDataMapMethod = JobExecutionContext.class.getMethod("getMergedJobDataMap", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Incompatible Quartz API: " + ex);
        }
    }

    public final void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            Scheduler scheduler = (Scheduler)ReflectionUtils.invokeMethod((Method)getSchedulerMethod, (Object)context);
            Map mergedJobDataMap = (Map)ReflectionUtils.invokeMethod((Method)getMergedJobDataMapMethod, (Object)context);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)this);
            MutablePropertyValues pvs = new MutablePropertyValues();
            pvs.addPropertyValues((Map)scheduler.getContext());
            pvs.addPropertyValues(mergedJobDataMap);
            bw.setPropertyValues((PropertyValues)pvs, true);
        }
        catch (SchedulerException ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        this.executeInternal(context);
    }

    protected abstract void executeInternal(JobExecutionContext var1) throws JobExecutionException;
}

