/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.services.accessor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.virgo.web.enterprise.services.accessor.VirgoEEBundleComparable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppBundleClassLoaderDelegateHook
implements ClassLoaderDelegateHook {
    private static final String GEMINI_WEB_TOMCAT_SYMBOLIC_NAME = "org.eclipse.gemini.web.tomcat";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAppBundleClassLoaderDelegateHook.class);
    private static final int MAX_API_SEARCH_DEPTH = 1;
    private static final int MAX_IMPL_SEARCH_DEPTH = 2;
    private static final int MAX_RESOURCE_SEARCH_DEPTH = 1;
    private final ThreadLocal<AtomicInteger> delegationInProgress = new ThreadLocal();
    private final Set<Bundle> apiBundles = new CopyOnWriteArraySet<Bundle>();
    private final Set<Bundle> implBundles = new CopyOnWriteArraySet<Bundle>();
    private final Map<Bundle, ClassLoader> implBundlesClassloaders = Collections.synchronizedMap(new TreeMap(new VirgoEEBundleComparable()));
    private final Map<Bundle, Set<String>> webAppBundles = new ConcurrentHashMap<Bundle, Set<String>>();
    private final Set<Bundle> postFindApiBundles = new CopyOnWriteArraySet<Bundle>();
    private Set<String> negativeCacheClassPrefixes = new HashSet<String>();
    private static Map<Bundle, CacheableObject> negativeCacheClassPerAPIBundle = new ConcurrentHashMap<Bundle, CacheableObject>();
    private static Map<Bundle, CacheableObject> negativeCacheResourcePerAPIBundle = new ConcurrentHashMap<Bundle, CacheableObject>();
    private static Map<Bundle, CacheableObject> negativeCacheClassPerTCCL = new ConcurrentHashMap<Bundle, CacheableObject>();
    private static Map<Bundle, CacheableObject> negativeCacheResourcePerTCCL = new ConcurrentHashMap<Bundle, CacheableObject>();
    private long timeToLive = 1200000L;

    static {
        Thread cleaner = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        this.removeFromNegativeCache(true, true);
                        this.removeFromNegativeCache(true, false);
                        this.removeFromNegativeCache(false, true);
                        this.removeFromNegativeCache(false, false);
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            private synchronized void removeFromNegativeCache(boolean isClass, boolean isAPI) {
                Collection values = isClass ? (isAPI ? negativeCacheClassPerAPIBundle.values() : negativeCacheClassPerTCCL.values()) : (isAPI ? negativeCacheResourcePerAPIBundle.values() : negativeCacheResourcePerTCCL.values());
                for (CacheableObject value : values) {
                    if (!value.isExpired()) continue;
                    values.remove(value);
                }
            }
        });
        cleaner.setPriority(1);
        cleaner.start();
    }

    WebAppBundleClassLoaderDelegateHook() {
        this.negativeCacheClassPrefixes.add("openwebbeans/Messages");
        this.negativeCacheClassPrefixes.add("com.sun.faces.LogStrings");
        this.negativeCacheClassPrefixes.add("javax.faces.LogStrings");
        this.negativeCacheClassPrefixes.add("org.apache.catalina.loader.LocalStrings");
        this.negativeCacheClassPrefixes.add("org.apache.tomcat.util.file.LocalStrings");
        this.negativeCacheClassPrefixes.add("org.apache.tomcat.util.scan.LocalStrings");
        this.negativeCacheClassPrefixes.add("org.apache.tomcat.util.http.mapper.LocalStrings");
        this.negativeCacheClassPrefixes.add("org.apache.tomcat.util.net.res.LocalStrings");
        this.negativeCacheClassPrefixes.add("org.apache.tomcat.util.threads.res.LocalStrings");
        this.negativeCacheClassPrefixes.add("ValidationMessages");
        this.negativeCacheClassPrefixes.add("org.apache.bval.jsr303.ValidationMessages");
        this.negativeCacheClassPrefixes.add("com.sun.xml.internal.messaging.saaj.soap.LocalStrings");
        this.negativeCacheClassPrefixes.add("org.apache.openejb.package-info");
        this.negativeCacheClassPrefixes.add("org.apache.openejb.monitoring.package-info");
        this.negativeCacheClassPrefixes.add("org.apache.geronimo.openejb.cdi.GeronimoWebBeansPlugin");
        this.negativeCacheClassPrefixes.add("org.apache.openejb.server.rest.RsRegistry");
        this.negativeCacheClassPrefixes.add("javax.faces.application.ConfigurableNavigationHandlerBeanInfo");
        this.negativeCacheClassPrefixes.add("javax.faces.application.NavigationHandlerBeanInfo");
        this.negativeCacheClassPrefixes.add("org.apache.webbeans.jsf.ConversationAwareViewHandlerBeanInfo");
        this.negativeCacheClassPrefixes.add("javax.faces.application.ViewHandlerWrapperBeanInfo");
        this.negativeCacheClassPrefixes.add("javax.faces.application.ViewHandlerBeanInfo");
        this.negativeCacheClassPrefixes.add("javax.faces.component.UIViewRootBeanInfo");
        this.negativeCacheClassPrefixes.add("javax.faces.component.UIComponentBaseBeanInfo");
        this.negativeCacheClassPrefixes.add("javax.faces.component.UIComponentBeanInfo");
        this.negativeCacheClassPrefixes.add("javax.management.MBean");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.APIMessages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.binding.xml.interceptor.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.bus.extension.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.bus.managers.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.common.injection.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.common.logging.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.common.util.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.endpoint.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.interceptor.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.jaxrs.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.jaxrs.impl.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.jaxrs.interceptor.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.jaxrs.model.wadl.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.jaxrs.provider.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.jaxrs.servlet.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.jaxrs.utils.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.resource.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.service.factory.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.service.invoker.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.service.model.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.staxutils.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.transport.http.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.transport.servlet.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.transport.https.Messages");
        this.negativeCacheClassPrefixes.add("org.apache.cxf.phase.Messages");
    }

    /*
     * Exception decompiling
     */
    public Class<?> postFindClass(String name, BundleClassLoader bcl, BundleData bd) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String postFindLibrary(String name, BundleClassLoader bcl, BundleData bd) {
        return null;
    }

    public URL postFindResource(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        if (this.shouldEnter(1)) {
            try {
                ClassLoader tccl;
                this.enter();
                Bundle bundle = bd.getBundle();
                if (this.webAppBundles.containsKey(bundle)) {
                    URL uRL = this.doFindApiResource(name);
                    return uRL;
                }
                if (this.implBundles.contains(bundle) && (tccl = Thread.currentThread().getContextClassLoader()) != null && this.isBundleWebAppCL(tccl) && !this.matchesNegativeCachePerTCCL(name, tccl, false)) {
                    URL resource = tccl.getResource(name);
                    if (resource != null) {
                        URL uRL = resource;
                        return uRL;
                    }
                    this.addToNegativeCachePerTCCL(name, tccl, false);
                }
            }
            finally {
                this.exit();
            }
        }
        return null;
    }

    private boolean shouldEnter(int maxDepth) {
        if (this.delegationInProgress.get() == null) {
            return true;
        }
        return this.delegationInProgress.get().get() < maxDepth;
    }

    private void enter() {
        if (this.delegationInProgress.get() == null) {
            this.delegationInProgress.set(new AtomicInteger(0));
        }
        this.delegationInProgress.get().incrementAndGet();
    }

    private void exit() {
        if (this.delegationInProgress.get() != null && this.delegationInProgress.get().get() > 0) {
            this.delegationInProgress.get().decrementAndGet();
        }
    }

    public Enumeration<URL> postFindResources(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        block10: {
            if (this.shouldEnter(1)) {
                try {
                    ClassLoader tccl;
                    this.enter();
                    Bundle bundle = bd.getBundle();
                    if (this.webAppBundles.containsKey(bundle)) {
                        Enumeration<URL> enumeration = this.doFindApiResources(name);
                        return enumeration;
                    }
                    if (!this.implBundles.contains(bundle) || (tccl = Thread.currentThread().getContextClassLoader()) == null) break block10;
                    try {
                        Enumeration<URL> enumeration = tccl.getResources(name);
                        return enumeration;
                    }
                    catch (IOException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Exception occurred while trying to find resources [" + name + "]. Exception message: " + e.getMessage());
                        }
                    }
                }
                finally {
                    this.exit();
                }
            }
        }
        return null;
    }

    public Class<?> preFindClass(String name, BundleClassLoader bcl, BundleData bd) throws ClassNotFoundException {
        if (this.matchesNegativeCache(name)) {
            return null;
        }
        if (this.shouldEnter(1)) {
            try {
                this.enter();
                Bundle bundle = bd.getBundle();
                if (this.webAppBundles.containsKey(bundle)) {
                    if (this.checkPackageInImport(name, this.webAppBundles.get(bundle))) {
                        return null;
                    }
                    Class<?> clazz = this.doFindApiClass(name);
                    return clazz;
                }
            }
            finally {
                this.exit();
            }
        }
        return null;
    }

    private boolean checkPackageInImport(String className, Set<String> importedPackages) {
        int index = className.lastIndexOf(46);
        String packageName = className;
        if (index > -1) {
            packageName = className.substring(0, index);
        }
        return importedPackages.contains(packageName);
    }

    public String preFindLibrary(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        return null;
    }

    public URL preFindResource(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        return null;
    }

    public Enumeration<URL> preFindResources(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        return null;
    }

    void addApiBundle(Bundle bundle) {
        this.apiBundles.add(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was added to API bundles.");
        }
    }

    void addPostApiBundle(Bundle bundle) {
        this.postFindApiBundles.add(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was added to post API bundles.");
        }
    }

    void addImplBundle(Bundle bundle) {
        ClassLoader cl;
        this.implBundles.add(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was added to Impl bundles.");
        }
        if ((cl = this.getBundleClassloader(bundle)) != null) {
            this.implBundlesClassloaders.put(bundle, cl);
        }
    }

    void removeApiBundle(Bundle bundle) {
        this.apiBundles.remove(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was removed from API bundles.");
        }
    }

    void removeImplBundle(Bundle bundle) {
        this.implBundlesClassloaders.remove(bundle);
        this.implBundles.remove(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was removed from Impl bundles.");
        }
    }

    void removePostApiBundle(Bundle bundle) {
        this.postFindApiBundles.remove(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was added to post API bundles.");
        }
    }

    void addWebAppBundle(Bundle bundle) {
        this.webAppBundles.put(bundle, this.cacheRequiredCapabilities(bundle));
    }

    void removeWebAppBundle(Bundle bundle) {
        this.webAppBundles.remove(bundle);
    }

    private Set<String> cacheRequiredCapabilities(Bundle bundle) {
        HashSet<String> importedPackages = new HashSet<String>();
        BundleWiring bundleWiring = ((BundleRevision)bundle.adapt(BundleRevision.class)).getWiring();
        importedPackages.addAll(this.getImportedPackages(bundleWiring));
        importedPackages.addAll(this.getImportedPackagesFromRequiredBundles(bundleWiring));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deploying web bundle " + bundle.getSymbolicName() + " with import packages " + importedPackages);
        }
        return importedPackages;
    }

    private Set<String> getImportedPackagesFromRequiredBundles(BundleWiring bundleWiring) {
        HashSet<String> importedPackages = new HashSet<String>();
        List requiredWires = bundleWiring.getRequiredWires("osgi.wiring.bundle");
        for (BundleWire requiredWire : requiredWires) {
            List capabilities = requiredWire.getProviderWiring().getCapabilities("osgi.wiring.package");
            for (BundleCapability capability : capabilities) {
                importedPackages.add((String)capability.getAttributes().get("osgi.wiring.package"));
            }
        }
        return importedPackages;
    }

    private Set<String> getImportedPackages(BundleWiring bundleWiring) {
        HashSet<String> importedPackages = new HashSet<String>();
        List requiredWires = bundleWiring.getRequiredWires("osgi.wiring.package");
        for (BundleWire requiredWire : requiredWires) {
            importedPackages.add((String)requiredWire.getCapability().getAttributes().get("osgi.wiring.package"));
        }
        return importedPackages;
    }

    ClassLoader[] getImplBundlesClassloaders() {
        return this.implBundlesClassloaders.values().toArray(new ClassLoader[this.implBundlesClassloaders.size()]);
    }

    private Class<?> doFindApiClass(String name) {
        for (Bundle bundle : this.apiBundles) {
            try {
                if (this.matchesNegativeCachePerAPIBundle(name, bundle, true)) continue;
                return bundle.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception occurred while trying to find class [" + name + "]. Exception message: " + e.getMessage());
                }
                this.addToNegativeCachePerAPIBundle(name, bundle, true);
            }
        }
        return null;
    }

    private URL doFindApiResource(String name) {
        for (Bundle bundle : this.apiBundles) {
            if (this.matchesNegativeCachePerAPIBundle(name, bundle, false)) continue;
            URL resource = bundle.getResource(name);
            if (resource != null) {
                return resource;
            }
            this.addToNegativeCachePerAPIBundle(name, bundle, false);
        }
        return null;
    }

    private Enumeration<URL> doFindApiResources(String name) {
        for (Bundle bundle : this.apiBundles) {
            try {
                Enumeration resources = bundle.getResources(name);
                if (resources == null) continue;
                return resources;
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Exception occurred while trying to find resources [" + name + "]. Exception message: " + e.getMessage());
            }
        }
        return null;
    }

    private ClassLoader getBundleClassloader(Bundle bundle) {
        if (bundle instanceof BundleHost) {
            return ((BundleHost)bundle).getClassLoader();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot obtain classloader for bundle " + bundle);
        }
        return null;
    }

    Set<Bundle> getApiBundles() {
        return this.apiBundles;
    }

    Set<Bundle> getImplBundles() {
        return this.implBundles;
    }

    private boolean isBundleWebAppCL(ClassLoader tccl) {
        Bundle bundle = FrameworkUtil.getBundle(tccl.getClass());
        return bundle != null && bundle.getSymbolicName().equals(GEMINI_WEB_TOMCAT_SYMBOLIC_NAME);
    }

    private String getClassPackage(String className) {
        int packageNameEndsIndex = className.lastIndexOf(".");
        if (packageNameEndsIndex != -1 && packageNameEndsIndex != className.length() - 1) {
            return className.substring(0, packageNameEndsIndex);
        }
        return "";
    }

    private boolean matchesNegativeCache(String className) {
        for (String prefix : this.negativeCacheClassPrefixes) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesNegativeCachePerTCCL(String name, ClassLoader tccl, boolean isClass) {
        if (tccl instanceof BundleReference) {
            Bundle bundle = ((BundleReference)tccl).getBundle();
            CacheableObject object = isClass ? negativeCacheClassPerTCCL.get(bundle) : negativeCacheResourcePerTCCL.get(bundle);
            if (object != null) {
                Queue<String> cache = object.getObject();
                for (String cachedName : cache) {
                    if (!name.equals(cachedName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private synchronized void addToNegativeCachePerTCCL(String name, ClassLoader tccl, boolean isClass) {
        if (tccl instanceof BundleReference) {
            Queue<String> classes;
            Bundle bundle = ((BundleReference)tccl).getBundle();
            CacheableObject object = isClass ? negativeCacheClassPerTCCL.get(bundle) : negativeCacheResourcePerTCCL.get(bundle);
            if (object == null) {
                classes = new ConcurrentLinkedQueue<String>();
                if (isClass) {
                    negativeCacheClassPerTCCL.put(bundle, new CacheableObject(classes, this.timeToLive));
                } else {
                    negativeCacheResourcePerTCCL.put(bundle, new CacheableObject(classes, this.timeToLive));
                }
            } else {
                classes = object.getObject();
            }
            classes.add(name);
        }
    }

    private boolean matchesNegativeCachePerAPIBundle(String name, Bundle apiBundle, boolean isClass) {
        CacheableObject object = isClass ? negativeCacheClassPerAPIBundle.get(apiBundle) : negativeCacheResourcePerAPIBundle.get(apiBundle);
        if (object != null) {
            Queue<String> cache = object.getObject();
            for (String cachedName : cache) {
                if (!name.equals(cachedName)) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void addToNegativeCachePerAPIBundle(String name, Bundle apiBundle, boolean isClass) {
        Queue<String> classes;
        CacheableObject object = isClass ? negativeCacheClassPerAPIBundle.get(apiBundle) : negativeCacheResourcePerAPIBundle.get(apiBundle);
        if (object == null) {
            classes = new ConcurrentLinkedQueue<String>();
            if (isClass) {
                negativeCacheClassPerAPIBundle.put(apiBundle, new CacheableObject(classes, this.timeToLive));
            } else {
                negativeCacheResourcePerAPIBundle.put(apiBundle, new CacheableObject(classes, this.timeToLive));
            }
        } else {
            classes = object.getObject();
        }
        classes.add(name);
    }

    static class CacheableObject {
        private Queue<String> object;
        private long expiration;

        CacheableObject(Queue<String> object, long timeToLive) {
            this.object = object;
            this.expiration = System.currentTimeMillis() + timeToLive;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expiration;
        }

        Queue<String> getObject() {
            return this.object;
        }
    }
}

