/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class QueryProxy
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, QueryProxy.class);
    public static final String PERSIST_NAME = "save";
    public static final String MERGE_NAME = "update";
    public static final String REMOVE_NAME = "delete";
    public static final String NAMED_QUERY_NAME = "namedQuery";
    public static final String NATIVE_QUERY_NAME = "nativeQuery";
    public static final String QUERY_NAME = "query";
    public static final String FIND_PREFIX = "find";
    public static final String BY = "By";
    public static final String AND = "And";
    private final Map<String, Class<?>> RETURN_TYPES = new ConcurrentHashMap();
    private final Map<String, List<String>> CONDITIONS = new ConcurrentHashMap<String, List<String>>();
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        if (PERSIST_NAME.equals(methodName)) {
            this.persist(args, returnType);
            return null;
        }
        if (MERGE_NAME.equals(methodName)) {
            return this.merge(args, returnType);
        }
        if (REMOVE_NAME.equals(methodName)) {
            this.remove(args, returnType);
            return null;
        }
        if (NAMED_QUERY_NAME.equals(methodName)) {
            return this.query(method, args, QueryType.NAMED);
        }
        if (NATIVE_QUERY_NAME.equals(methodName)) {
            return this.query(method, args, QueryType.NATIVE);
        }
        if (QUERY_NAME.equals(methodName)) {
            return this.query(method, args, QueryType.OTHER);
        }
        if (methodName.startsWith(FIND_PREFIX)) {
            return this.find(method, args);
        }
        throw new IllegalArgumentException("method not yet managed");
    }

    private Object query(Method method, Object[] args, QueryType type) {
        Query query;
        if (args.length < 1) {
            throw new IllegalArgumentException("query() needs at least the query name");
        }
        int matched = 0;
        if (String.class.isAssignableFrom(args[0].getClass())) {
            switch (type) {
                case NAMED: {
                    query = this.em.createNamedQuery((String)args[0]);
                    break;
                }
                case NATIVE: {
                    query = this.em.createNativeQuery((String)args[0]);
                    break;
                }
                default: {
                    query = this.em.createQuery((String)args[0]);
                }
            }
            ++matched;
            for (int i = 1; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (Map.class.isAssignableFrom(args[i].getClass())) {
                    for (Map.Entry entry : ((Map)args[i]).entrySet()) {
                        query = query.setParameter((String)entry.getKey(), entry.getValue());
                    }
                    ++matched;
                    continue;
                }
                if (args[i].getClass().isArray()) {
                    Object[] array = (Object[])args[i];
                    for (int j = 0; j < array.length; ++j) {
                        query = query.setParameter(j, array[j]);
                    }
                    ++matched;
                    continue;
                }
                if (this.isInt(args[i].getClass())) {
                    int next = i + 1;
                    if (args.length == next || !this.isInt(args[next].getClass())) {
                        throw new IllegalArgumentException("if you provide a firstResult (first int parameter)you should provide a maxResult too");
                    }
                    int first = (Integer)args[i];
                    int max = (Integer)args[next];
                    query = query.setFirstResult(first);
                    query = query.setMaxResults(max);
                    matched += 2;
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("not managed parameter " + args[i] + " of type " + args[i].getClass());
            }
            if (matched != args.length) {
                throw new IllegalArgumentException("all argument was not used, please check you signature looks like: <ReturnType> query(String name, Map<String, ?> parameters, int firstResult, int maxResult)");
            }
        } else {
            throw new IllegalArgumentException("query() needs at least the query name of type String");
        }
        return this.getQueryResult(method, query);
    }

    private Class<?> getReturnedType(Method method) {
        Class<?> type;
        String methodName = method.getName();
        if (this.RETURN_TYPES.containsKey(methodName)) {
            type = this.RETURN_TYPES.get(methodName);
        } else {
            type = this.getGenericType(method.getGenericReturnType());
            this.RETURN_TYPES.put(methodName, type);
        }
        return type;
    }

    private Object getQueryResult(Method method, Query query) {
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            return query.getResultList();
        }
        return query.getSingleResult();
    }

    private Object find(Method method, Object[] args) {
        String methodName = method.getName();
        Class<?> type = this.getReturnedType(method);
        Query query = this.createFinderQuery(this.em, methodName, type, args);
        return this.getQueryResult(method, query);
    }

    private void remove(Object[] args, Class<?> returnType) {
        Object entity;
        if (args != null && args.length == 1 && returnType.equals(Void.TYPE)) {
            entity = args[0];
            if (!this.em.contains(entity)) {
                String idValue;
                Class<?> entityClass = entity.getClass();
                EntityType et = this.em.getMetamodel().entity(entityClass);
                if (!et.hasSingleIdAttribute()) {
                    throw new IllegalArgumentException("Dynamic EJB doesn't manage IdClass yet");
                }
                SingularAttribute id = null;
                for (SingularAttribute sa : et.getSingularAttributes()) {
                    if (!sa.isId()) continue;
                    id = sa;
                    break;
                }
                if (id == null) {
                    throw new IllegalArgumentException("id field not found");
                }
                String idName = id.getName();
                try {
                    idValue = BeanUtils.getProperty((Object)entity, (String)idName);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException("can't invoke to get entity id");
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("can't find the method to get entity id");
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("can't access field/method to get entity id");
                }
                entity = this.em.getReference(et.getJavaType(), (Object)idValue);
                if (entity == null) {
                    throw new IllegalArgumentException("entity " + entity + " is not managed and can't be found.");
                }
            }
        } else {
            throw new IllegalArgumentException("delete should have only one parameter and return void");
        }
        this.em.remove(entity);
    }

    private Object merge(Object[] args, Class<?> returnType) {
        if (args != null && args.length == 1 && returnType.equals(args[0].getClass())) {
            return this.em.merge(args[0]);
        }
        throw new IllegalArgumentException("update should have only one parameter and return the same type than the parameter type");
    }

    private void persist(Object[] args, Class<?> returnType) {
        if (args == null || args.length != 1 || !returnType.equals(Void.TYPE)) {
            throw new IllegalArgumentException("save should have only one parameter and return void");
        }
        this.em.persist(args[0]);
    }

    private Class<?> getGenericType(Type type) {
        ParameterizedType pt;
        if (type instanceof ParameterizedType && (pt = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return (Class)pt.getActualTypeArguments()[0];
        }
        return (Class)Class.class.cast(type);
    }

    private <T> Query createFinderQuery(EntityManager entityManager, String methodName, Class<T> entityType, Object[] args) {
        List<String> conditions = this.parseMethodName(methodName);
        EntityType et = entityManager.getMetamodel().entity(entityType);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery();
        Root from = query.from(entityType);
        query = query.select((Selection)from);
        int i = 0;
        Predicate where = null;
        for (String condition : conditions) {
            Predicate currentClause;
            SingularAttribute attribute = et.getSingularAttribute(condition);
            Path path = from.get(attribute);
            Class javaType = attribute.getType().getJavaType();
            if (javaType.equals(String.class)) {
                currentClause = cb.like((Expression)path, (String)args[i++]);
            } else if (Number.class.isAssignableFrom(javaType) || javaType.isPrimitive()) {
                currentClause = cb.equal((Expression)path, args[i++]);
            } else {
                LOGGER.warning("field " + condition + " not found, ignoring");
                continue;
            }
            if (where == null) {
                where = currentClause;
                continue;
            }
            where = cb.and((Expression)where, (Expression)currentClause);
        }
        if (where != null) {
            query = query.where(where);
        }
        TypedQuery emQuery = entityManager.createQuery(query);
        if (args != null && args.length == conditions.size() + 2 && this.isInt(args[args.length - 2].getClass()) && this.isInt(args[args.length - 1].getClass())) {
            int first = (Integer)args[args.length - 2];
            int max = (Integer)args[args.length - 1];
            emQuery.setFirstResult(first);
            emQuery.setMaxResults(max);
        }
        return emQuery;
    }

    private boolean isInt(Class<?> aClass) {
        return Integer.TYPE.equals(aClass) || Integer.class.equals(aClass);
    }

    private List<String> parseMethodName(String methodName) {
        ArrayList<String> parsed;
        if (this.CONDITIONS.containsKey(methodName)) {
            parsed = this.CONDITIONS.get(methodName);
        } else {
            parsed = new ArrayList();
            String toParse = methodName.substring(FIND_PREFIX.length());
            if (toParse.startsWith(BY)) {
                String[] columns;
                toParse = toParse.substring(2);
                for (String column : columns = toParse.split(AND)) {
                    parsed.add(StringUtils.uncapitalize((String)column));
                }
            }
            this.CONDITIONS.put(methodName, parsed);
        }
        return parsed;
    }

    public String toString() {
        return "OpenEJB :: QueryProxy";
    }

    private static enum QueryType {
        NAMED,
        NATIVE,
        OTHER;

    }
}

