/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.remote;

import java.io.File;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.repository.configuration.RemoteRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.BaseRepository;
import org.eclipse.virgo.repository.internal.RepositoryLogEvents;
import org.eclipse.virgo.repository.internal.management.StandardRemoteRepositoryInfo;
import org.eclipse.virgo.repository.internal.remote.ArtifactDescriptorStoreWatcher;
import org.eclipse.virgo.repository.internal.remote.MutableArtifactDescriptorDepository;
import org.eclipse.virgo.repository.management.RepositoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRepository
extends BaseRepository {
    private static final String SCHEME_HTTP = "http";
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteRepository.class);
    private final ArtifactDescriptorStoreWatcher watcher;
    private final File cacheDirectory;

    public RemoteRepository(RemoteRepositoryConfiguration configuration, EventLogger eventLogger) {
        this(configuration, new MutableArtifactDescriptorDepository(configuration.getName(), eventLogger), eventLogger);
    }

    private RemoteRepository(RemoteRepositoryConfiguration configuration, MutableArtifactDescriptorDepository depository, EventLogger eventLogger) {
        super(configuration, depository);
        this.cacheDirectory = configuration.getCacheDirectory();
        if (!SCHEME_HTTP.equals(configuration.getRepositoryUri().getScheme())) {
            LOGGER.error("Uri '{}' scheme not http for remote repository '{}'.", (Object)configuration.getRepositoryUri(), (Object)this.getName());
            eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_NOT_CREATED, new Object[]{configuration.getName()});
            throw new IllegalArgumentException("Proxy only supports http");
        }
        this.watcher = new ArtifactDescriptorStoreWatcher(depository, configuration);
    }

    @Override
    protected void start() {
        super.start();
        this.watcher.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.watcher.stop();
    }

    @Override
    protected RepositoryInfo createMBean() {
        return new StandardRemoteRepositoryInfo(this.getName(), this.getDepository());
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }
}

