/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.importexpansion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;

class BundleManifestProcessor {
    private static final String BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME = "bundle-symbolic-name";
    private static final String BUNDLE_VERSION_ATTRIBUTE_NAME = "bundle-version";
    private static final String VERSION_ATTRIBUTE_NAME = "version";

    BundleManifestProcessor() {
    }

    static List<ImportedPackage> createImportedPackageForEachExportedPackage(List<ExportedPackage> packageExports, String bundleSymbolicName, String bundleVersion) {
        BundleManifest manifest = BundleManifestFactory.createBundleManifest();
        BundleManifestProcessor.doCreateImportedPackageForEachExportedPackage(packageExports, bundleSymbolicName, bundleVersion, null, manifest);
        return manifest.getImportPackage().getImportedPackages();
    }

    static List<ImportedPackage> createImportedPackageForEachExportedPackageOfFragment(List<ExportedPackage> packageExports, String bundleSymbolicName, VersionRange bundleVersionRange) {
        BundleManifest manifest = BundleManifestFactory.createBundleManifest();
        BundleManifestProcessor.doCreateImportedPackageForEachExportedPackage(packageExports, bundleSymbolicName, null, bundleVersionRange, manifest);
        return manifest.getImportPackage().getImportedPackages();
    }

    static Result<ImportedPackage[]> createImportedPackageForEachExportedPackage(BundleManifest[] bundleManifests) {
        ArrayList<ImportedPackage> allImportedPackages = new ArrayList<ImportedPackage>();
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        BundleManifest[] bundleManifestArray = bundleManifests;
        int n = bundleManifests.length;
        int n2 = 0;
        while (n2 < n) {
            BundleManifest bundleManifest = bundleManifestArray[n2];
            List packageExports = bundleManifest.getExportPackage().getExportedPackages();
            BundleManifest resultManifest = BundleManifestFactory.createBundleManifest();
            BundleManifestProcessor.doCreateImportedPackageForEachExportedPackage(packageExports, null, null, null, resultManifest);
            List packageImports = resultManifest.getImportPackage().getImportedPackages();
            for (ImportedPackage packageImport : packageImports) {
                String name = packageImport.getPackageName();
                if (!BundleManifestProcessor.containsImport(allImportedPackages, name)) {
                    allImportedPackages.add(packageImport);
                    continue;
                }
                warnings.add(new Warning(Code.DUPLICATE_PACKAGE_EXPORTS, name));
            }
            ++n2;
        }
        return new Result<ImportedPackage[]>(allImportedPackages.toArray(new ImportedPackage[allImportedPackages.size()]), warnings.toArray(new Warning[warnings.size()]));
    }

    private static void doCreateImportedPackageForEachExportedPackage(List<ExportedPackage> packageExports, String bundleSymbolicName, String version, VersionRange versionRange, BundleManifest bundleManifest) {
        for (ExportedPackage packageExport : packageExports) {
            String name = packageExport.getPackageName();
            List packageImports = bundleManifest.getImportPackage().getImportedPackages();
            ImportedPackage packageImport = BundleManifestProcessor.findImport(packageImports, name);
            if (packageImport == null) {
                packageImport = bundleManifest.getImportPackage().addImportedPackage(name);
            }
            List mandatory = packageExport.getMandatory();
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (mandatory != null) {
                for (String attrName : mandatory) {
                    if (!packageExport.getAttributes().containsKey(attrName)) continue;
                    attributes.put(attrName, (String)packageExport.getAttributes().get(attrName));
                }
            }
            if (bundleSymbolicName != null) {
                attributes.put(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE_NAME, bundleSymbolicName);
            }
            if (StringUtils.hasText((String)version)) {
                VersionRange vr;
                try {
                    vr = VersionRange.createExactRange((Version)new Version(version));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    vr = new VersionRange(version);
                }
                attributes.put(BUNDLE_VERSION_ATTRIBUTE_NAME, vr.toParseString());
            }
            if (versionRange != null) {
                if (!versionRange.isFloorInclusive() || versionRange.isCeilingInclusive() || !versionRange.getFloor().equals((Object)Version.emptyVersion)) {
                    attributes.put(BUNDLE_VERSION_ATTRIBUTE_NAME, versionRange.toParseString());
                }
                if (!versionRange.isExact()) {
                    VersionRange packageVersionRange = VersionRange.createExactRange((Version)packageExport.getVersion());
                    attributes.put(VERSION_ATTRIBUTE_NAME, packageVersionRange.toParseString());
                }
            }
            packageImport.getAttributes().putAll(attributes);
        }
    }

    private static boolean containsImport(List<ImportedPackage> imports, String packageName) {
        for (ImportedPackage packageImport : imports) {
            if (!packageImport.getPackageName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private static ImportedPackage findImport(List<ImportedPackage> imports, String packageName) {
        for (ImportedPackage packageImport : imports) {
            if (!packageImport.getPackageName().equals(packageName)) continue;
            return packageImport;
        }
        return null;
    }

    public static enum Code {
        DUPLICATE_PACKAGE_EXPORTS;

    }

    public static class Result<T> {
        private final T output;
        private final Warning[] warnings;

        private Result(T output, Warning[] warnings) {
            this.output = output;
            this.warnings = warnings;
        }

        public T getOutput() {
            return this.output;
        }

        public Warning[] getWarnings() {
            return (Warning[])this.warnings.clone();
        }

        public boolean success() {
            return this.warnings.length == 0;
        }
    }

    public static class Warning {
        private final Code code;
        private final String reason;

        private Warning(Code code, String reason) {
            this.code = code;
            this.reason = reason;
        }

        public Code getCode() {
            return this.code;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Warning)) {
                return false;
            }
            Warning that = (Warning)other;
            return this.getCode().equals((Object)that.getCode()) && this.getReason().equals(that.getReason());
        }

        public int hashCode() {
            return this.code.hashCode();
        }
    }
}

