/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.management;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiRequiredBundle;
import org.eclipse.virgo.kernel.userregion.internal.management.JMXQuasiMinimalBundle;
import org.eclipse.virgo.kernel.userregion.internal.management.JMXQuasiWire;

public final class JMXQuasiBundle
extends JMXQuasiMinimalBundle {
    private final QuasiBundle quasiBundle;

    protected JMXQuasiBundle(QuasiBundle quasiBundle) {
        super(quasiBundle);
        this.quasiBundle = quasiBundle;
    }

    public final JMXQuasiWire[] getProvidedWires() {
        List exportPackages = this.quasiBundle.getExportPackages();
        ArrayList<JMXQuasiWire> wires = new ArrayList<JMXQuasiWire>();
        for (QuasiExportPackage quasiExportPackage : exportPackages) {
            List consumers = quasiExportPackage.getConsumers();
            for (QuasiImportPackage quasiImportPackage : consumers) {
                if (quasiImportPackage == null) continue;
                wires.add(new JMXQuasiWire(quasiImportPackage));
            }
        }
        List fragments = this.quasiBundle.getFragments();
        if (fragments != null && fragments.size() > 0) {
            for (QuasiBundle fragment : fragments) {
                wires.add(new JMXQuasiWire(this.quasiBundle, fragment));
            }
        }
        return wires.toArray(new JMXQuasiWire[wires.size()]);
    }

    public final JMXQuasiWire[] getRequiredWires() {
        List hosts;
        List importPackages = this.quasiBundle.getImportPackages();
        ArrayList<JMXQuasiWire> wires = new ArrayList<JMXQuasiWire>();
        for (QuasiImportPackage quasiImportPackage : importPackages) {
            if (quasiImportPackage == null) continue;
            wires.add(new JMXQuasiWire(quasiImportPackage));
        }
        List requiredBundles = this.quasiBundle.getRequiredBundles();
        if (requiredBundles != null && requiredBundles.size() > 0) {
            for (QuasiRequiredBundle quasiRequiredBundle : requiredBundles) {
                wires.add(new JMXQuasiWire(quasiRequiredBundle, this.quasiBundle));
            }
        }
        if ((hosts = this.quasiBundle.getHosts()) != null && hosts.size() > 0) {
            for (QuasiBundle host : hosts) {
                wires.add(new JMXQuasiWire(host, this.quasiBundle));
            }
        }
        return wires.toArray(new JMXQuasiWire[wires.size()]);
    }
}

