/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.osgi.framework.ServiceEvent;
import org.osgi.jmx.framework.ServiceStateMBean;

public final class OSGiServiceEvent {
    private long bundleId;
    private int eventType;
    private String[] interfaces;
    private String location;
    private String symbolicName;
    private long serviceId;

    public OSGiServiceEvent(ServiceEvent event) {
        this.serviceId = (Long)event.getServiceReference().getProperty("service.id");
        this.bundleId = event.getServiceReference().getBundle().getBundleId();
        this.location = event.getServiceReference().getBundle().getLocation();
        this.symbolicName = event.getServiceReference().getBundle().getSymbolicName();
        this.interfaces = (String[])event.getServiceReference().getProperty("objectClass");
        this.eventType = event.getType();
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.serviceId);
        items.put("BundleIdentifier", this.bundleId);
        items.put("BundleLocation", this.location);
        items.put("BundleSymbolicName", this.symbolicName);
        items.put("Identifier", this.serviceId);
        items.put("objectClass", this.interfaces);
        items.put("ServiceEvent", this.eventType);
        try {
            return new CompositeDataSupport(ServiceStateMBean.SERVICE_EVENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service event open data", e);
        }
    }
}

