/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.virgo.kernel.osgi.framework.BundleClassLoaderUnavailableException;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFramework;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleThreadContextManager {
    private static final String WRAPPED_NULL = "WRAPPED_NULL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object monitor = new Object();
    private final OsgiFramework osgi;
    private final Bundle threadContextBundle;
    private final String scopeName;
    private final TracingService tracingService;
    private final ThreadLocal<BlockingDeque<ClassLoader>> contextClassLoaderStack = new ContextClassLoaderStackThreadLocal();
    private final ThreadLocal<BlockingDeque<String>> applicationTraceNameStack = new ApplicationTraceNameStackThreadLocal();

    public BundleThreadContextManager(@NonNull OsgiFramework osgi, @NonNull Bundle threadContextBundle, String scopeName, @NonNull TracingService tracingService) {
        this.osgi = osgi;
        this.threadContextBundle = threadContextBundle;
        this.scopeName = scopeName;
        this.tracingService = tracingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushThreadContext() {
        Object object = this.monitor;
        synchronized (object) {
            this.pushThreadContextClassLoader();
            this.applicationTraceNameStack.get().push(this.wrapNull(this.tracingService.getCurrentApplicationName()));
            this.tracingService.setCurrentApplicationName(this.scopeName);
        }
    }

    private String wrapNull(String string) {
        return string != null ? string : WRAPPED_NULL;
    }

    private String unwrapNull(String string) {
        return WRAPPED_NULL.equals(string) ? null : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popThreadContext() {
        Object object = this.monitor;
        synchronized (object) {
            this.popThreadContextClassLoader();
            this.tracingService.setCurrentApplicationName(this.unwrapNull((String)this.applicationTraceNameStack.get().pop()));
        }
    }

    private void pushThreadContextClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
        this.contextClassLoaderStack.get().push(oldContextClassLoader);
        int state = this.threadContextBundle.getState();
        if (state != 2 && state != 1) {
            ClassLoader newContextClassLoader = null;
            try {
                newContextClassLoader = this.osgi.getBundleClassLoader(this.threadContextBundle);
            }
            catch (BundleClassLoaderUnavailableException bundleClassLoaderUnavailableException) {
                this.logger.info("Bundle class loader not available, it may not be resolved");
            }
            if (newContextClassLoader != null) {
                currentThread.setContextClassLoader(newContextClassLoader);
                this.logger.info("Thread context class loader '{}' pushed and set to '{}'", (Object)oldContextClassLoader, (Object)newContextClassLoader);
            } else {
                this.logger.info("Thread context class loader not found for bundle '{}'", (Object)this.threadContextBundle.getSymbolicName());
            }
        }
    }

    private void popThreadContextClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
        ClassLoader newContextClassLoader = (ClassLoader)this.contextClassLoaderStack.get().pop();
        currentThread.setContextClassLoader(newContextClassLoader);
        this.logger.info("Thread context class loader '{}' popped and set to '{}'", (Object)oldContextClassLoader, (Object)newContextClassLoader);
    }

    private static final class ApplicationTraceNameStackThreadLocal
    extends ThreadLocal<BlockingDeque<String>> {
        private ApplicationTraceNameStackThreadLocal() {
        }

        @Override
        protected BlockingDeque<String> initialValue() {
            return new LinkedBlockingDeque<String>();
        }
    }

    private static final class ContextClassLoaderStackThreadLocal
    extends ThreadLocal<BlockingDeque<ClassLoader>> {
        private ContextClassLoaderStackThreadLocal() {
        }

        @Override
        protected BlockingDeque<ClassLoader> initialValue() {
            return new LinkedBlockingDeque<ClassLoader>();
        }
    }
}

