/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.management.internal.system;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.management.internal.system.SystemManagementExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiBeanSystemManagementExporter<T>
implements SystemManagementExporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    @Override
    public void register(String managementDomain) {
        for (T bean : this.getBeans()) {
            try {
                this.server.registerMBean(bean, this.getObjectName(managementDomain, bean));
            }
            catch (Exception exception) {
                this.logger.warn("Unable to register system information {} for management", (Object)this.getName(bean));
            }
        }
    }

    @Override
    public void unregister(String managementDomain) {
        for (T bean : this.getBeans()) {
            try {
                this.server.unregisterMBean(this.getObjectName(managementDomain, bean));
            }
            catch (Exception exception) {
                this.logger.warn("Unable to unregister system information {} from management", (Object)this.getName(bean));
            }
        }
    }

    abstract List<T> getBeans();

    abstract ObjectName getObjectName(String var1, T var2) throws MalformedObjectNameException, NullPointerException;

    abstract String getName(T var1);
}

