/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.dmfragment.internal;

import org.eclipse.virgo.kernel.dmfragment.ModuleBeanFactoryPostProcessor;
import org.eclipse.virgo.kernel.dmfragment.internal.KernelLoadTimeWeaver;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;

final class LoadTimeWeaverPostProcessor
implements ModuleBeanFactoryPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    LoadTimeWeaverPostProcessor() {
    }

    @Override
    public void postProcess(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory.containsBean("loadTimeWeaver")) {
            AbstractBeanDefinition ltwBean = (AbstractBeanDefinition)beanFactory.getBeanDefinition("loadTimeWeaver");
            ltwBean.setBeanClass(KernelLoadTimeWeaver.class);
            this.logger.info("Found load-time weaver bean for bundle '{}'. Switching to ServerLoadTimeWeaver.", (Object)bundleContext.getBundle());
        } else {
            this.logger.info("Load-time weaving not enabled for bundle '{}',", (Object)bundleContext.getBundle());
        }
    }
}

