/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.common.StringUtils;
import org.osgi.framework.Bundle;

public class SpringUtils {
    private static final String SPRING_DM_CONTEXT_DIR = "/META-INF/spring/";
    private static final String BLUEPRINT_CONTEXT_DIR = "/OSGI-INF/blueprint/";
    private static final String CONTEXT_FILES = "*.xml";
    private static final String BUNDLE_URL_PREFIX = "osgibundle:";
    private static final String SPRING_CONTEXT_HEADER = "Spring-Context";
    private static final String BUNDLE_BLUEPRINT_HEADER = "Bundle-Blueprint";
    private static final String DIRECTIVE_SEPARATOR = ";";
    private static final String CONTEXT_LOCATION_SEPARATOR = ",";
    private static final String CONFIG_WILDCARD = "*";
    private static final String SPRING_DM_DEFAULT_CONFIG = "osgibundle:/META-INF/spring/*.xml";
    private static final String BLUEPRINT_DEFAULT_CONFIG = "osgibundle:/OSGI-INF/blueprint/*.xml";

    public SpringUtils() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String[] getSpringContextConfigurations(Bundle bundle) {
        try {
            Object[] locations = SpringUtils.getSpringContextHeaderLocations(bundle.getHeaders());
            if (SpringUtils.isArrayEmpty(locations)) {
                Enumeration defaultConfig = bundle.findEntries(SPRING_DM_CONTEXT_DIR, CONTEXT_FILES, false);
                if (defaultConfig != null && defaultConfig.hasMoreElements()) {
                    return new String[]{SPRING_DM_DEFAULT_CONFIG};
                }
                defaultConfig = bundle.findEntries(BLUEPRINT_CONTEXT_DIR, CONTEXT_FILES, false);
                if (defaultConfig != null && defaultConfig.hasMoreElements()) {
                    return new String[]{BLUEPRINT_DEFAULT_CONFIG};
                }
                return new String[0];
            }
            return locations;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static String[] getSpringContextHeaderLocations(Dictionary<String, String> headers) {
        try {
            String[] ctxEntries;
            String header = SpringUtils.getSpringContextHeader(headers);
            if (StringUtils.hasText((String)header) && ';' != header.charAt(0)) {
                String locations = StringUtils.tokenizeToStringArray((String)header, (String)DIRECTIVE_SEPARATOR)[0];
                ctxEntries = StringUtils.tokenizeToStringArray((String)locations, (String)CONTEXT_LOCATION_SEPARATOR);
                int i = 0;
                while (i < ctxEntries.length) {
                    if (CONFIG_WILDCARD.equals(ctxEntries[i])) {
                        ctxEntries[i] = SPRING_DM_DEFAULT_CONFIG;
                    }
                    ++i;
                }
            } else {
                header = SpringUtils.getBundleBlueprintHeader(headers);
                if (StringUtils.hasText((String)header) && ';' != header.charAt(0)) {
                    String locations = StringUtils.tokenizeToStringArray((String)header, (String)DIRECTIVE_SEPARATOR)[0];
                    ctxEntries = StringUtils.tokenizeToStringArray((String)locations, (String)CONTEXT_LOCATION_SEPARATOR);
                    int i = 0;
                    while (i < ctxEntries.length) {
                        if (CONFIG_WILDCARD.equals(ctxEntries[i])) {
                            ctxEntries[i] = BLUEPRINT_DEFAULT_CONFIG;
                        }
                        ++i;
                    }
                } else {
                    ctxEntries = new String[]{};
                }
            }
            return ctxEntries;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static boolean isArrayEmpty(Object[] array) {
        try {
            return array == null || array.length == 0;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static String getSpringContextHeader(Dictionary headers) {
        try {
            Object header = null;
            if (headers != null) {
                header = headers.get(SPRING_CONTEXT_HEADER);
            }
            return header != null ? header.toString().trim() : null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static String getBundleBlueprintHeader(Dictionary headers) {
        try {
            Object header = null;
            if (headers != null) {
                header = headers.get(BUNDLE_BLUEPRINT_HEADER);
            }
            return header != null ? header.toString().trim() : null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static boolean isSpringDMPoweredBundle(Bundle bundle) {
        try {
            Object[] configurations = SpringUtils.getSpringContextConfigurations(bundle);
            return !SpringUtils.isArrayEmpty(configurations);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

