/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.gemini.management.framework.CustomBundleStateMBean;
import org.eclipse.gemini.management.internal.BundleUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.jmx.Item;
import org.osgi.jmx.framework.BundleStateMBean;

public final class OSGiBundle {
    private Bundle bundle;

    public OSGiBundle(Bundle b) {
        this.bundle = b;
    }

    public static TabularData tableFrom(List<OSGiBundle> bundles, String ... bundleTypeItems) throws IOException {
        List<String> bundleTypes = Arrays.asList(bundleTypeItems);
        CompositeType computeBundleType = OSGiBundle.computeBundleType(bundleTypes);
        TabularDataSupport table = new TabularDataSupport(Item.tabularType((String)"BUNDLES", (String)"A list of bundles", (CompositeType)computeBundleType, (String[])new String[]{"Identifier"}));
        for (OSGiBundle bundle : bundles) {
            table.put(bundle.asCompositeData(computeBundleType, bundleTypes));
        }
        return table;
    }

    private static CompositeType computeBundleType(List<String> bundleTypes) {
        ArrayList<Item> bundleTypeItems = new ArrayList<Item>();
        bundleTypeItems.add(BundleStateMBean.IDENTIFIER_ITEM);
        if (bundleTypes.contains("Location")) {
            bundleTypeItems.add(BundleStateMBean.LOCATION_ITEM);
        }
        if (bundleTypes.contains("SymbolicName")) {
            bundleTypeItems.add(BundleStateMBean.SYMBOLIC_NAME_ITEM);
        }
        if (bundleTypes.contains("Version")) {
            bundleTypeItems.add(BundleStateMBean.VERSION_ITEM);
        }
        if (bundleTypes.contains("StartLevel")) {
            bundleTypeItems.add(BundleStateMBean.START_LEVEL_ITEM);
        }
        if (bundleTypes.contains("State")) {
            bundleTypeItems.add(BundleStateMBean.STATE_ITEM);
        }
        if (bundleTypes.contains("LastModified")) {
            bundleTypeItems.add(BundleStateMBean.LAST_MODIFIED_ITEM);
        }
        if (bundleTypes.contains("PersistentlyStarted")) {
            bundleTypeItems.add(BundleStateMBean.PERSISTENTLY_STARTED_ITEM);
        }
        if (bundleTypes.contains(0x100000)) {
            bundleTypeItems.add(CustomBundleStateMBean.ACTIVATION_POLICY_ITEM);
        }
        if (bundleTypes.contains("RemovalPending")) {
            bundleTypeItems.add(BundleStateMBean.REMOVAL_PENDING_ITEM);
        }
        if (bundleTypes.contains("Required")) {
            bundleTypeItems.add(BundleStateMBean.REQUIRED_ITEM);
        }
        if (bundleTypes.contains("Fragment")) {
            bundleTypeItems.add(BundleStateMBean.FRAGMENT_ITEM);
        }
        if (bundleTypes.contains("RegisteredServices")) {
            bundleTypeItems.add(BundleStateMBean.REGISTERED_SERVICES_ITEM);
        }
        if (bundleTypes.contains("ServicesInUse")) {
            bundleTypeItems.add(BundleStateMBean.SERVICES_IN_USE_ITEM);
        }
        if (bundleTypes.contains("Headers")) {
            bundleTypeItems.add(BundleStateMBean.HEADERS_ITEM);
        }
        if (bundleTypes.contains("ExportedPackages")) {
            bundleTypeItems.add(BundleStateMBean.EXPORTED_PACKAGES_ITEM);
        }
        if (bundleTypes.contains("ImportedPackages")) {
            bundleTypeItems.add(BundleStateMBean.IMPORTED_PACKAGES_ITEM);
        }
        if (bundleTypes.contains("Fragments")) {
            bundleTypeItems.add(BundleStateMBean.FRAGMENTS_ITEM);
        }
        if (bundleTypes.contains("Hosts")) {
            bundleTypeItems.add(BundleStateMBean.HOSTS_ITEM);
        }
        if (bundleTypes.contains("RequiringBundles")) {
            bundleTypeItems.add(BundleStateMBean.REQUIRING_BUNDLES_ITEM);
        }
        if (bundleTypes.contains("RequiredBundles")) {
            bundleTypeItems.add(BundleStateMBean.REQUIRED_BUNDLES_ITEM);
        }
        CompositeType currentCompositeType = Item.compositeType((String)"BUNDLE", (String)"This type encapsulates OSGi bundles", (Item[])bundleTypeItems.toArray(new Item[0]));
        return currentCompositeType;
    }

    private CompositeData asCompositeData(CompositeType computeBundleType, List<String> bundleTypes) throws IOException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.getIdentifier());
        if (bundleTypes.contains("Location")) {
            items.put("Location", this.getLocation());
        }
        if (bundleTypes.contains("SymbolicName")) {
            items.put("SymbolicName", this.getSymbolicName());
        }
        if (bundleTypes.contains("Version")) {
            items.put("Version", this.getVersion());
        }
        if (bundleTypes.contains("StartLevel")) {
            items.put("StartLevel", this.getStartLevel());
        }
        if (bundleTypes.contains("State")) {
            items.put("State", this.getState());
        }
        if (bundleTypes.contains("LastModified")) {
            items.put("LastModified", this.getLastModified());
        }
        if (bundleTypes.contains("PersistentlyStarted")) {
            items.put("PersistentlyStarted", this.isPersistentlyStarted());
        }
        if (bundleTypes.contains(0x100000)) {
            items.put("ActivationPolicyUsed", this.isActivationPolicyUsed());
        }
        if (bundleTypes.contains("RemovalPending")) {
            items.put("RemovalPending", this.isRemovalPending());
        }
        if (bundleTypes.contains("Required")) {
            items.put("Required", this.isRequired());
        }
        if (bundleTypes.contains("Fragment")) {
            items.put("Fragment", this.isFragment());
        }
        if (bundleTypes.contains("RegisteredServices")) {
            items.put("RegisteredServices", this.getRegisteredServices());
        }
        if (bundleTypes.contains("ServicesInUse")) {
            items.put("ServicesInUse", this.getServicesInUse());
        }
        if (bundleTypes.contains("Headers")) {
            items.put("Headers", OSGiBundle.headerTable(this.getHeaders()));
        }
        if (bundleTypes.contains("ExportedPackages")) {
            items.put("ExportedPackages", this.getExportedPackages());
        }
        if (bundleTypes.contains("ImportedPackages")) {
            items.put("ImportedPackages", this.getImportedPackages());
        }
        if (bundleTypes.contains("Fragments")) {
            items.put("Fragments", this.getFragments());
        }
        if (bundleTypes.contains("Hosts")) {
            items.put("Hosts", this.getHosts());
        }
        if (bundleTypes.contains("RequiringBundles")) {
            items.put("RequiringBundles", this.getRequiringBundles());
        }
        if (bundleTypes.contains("RequiredBundles")) {
            items.put("RequiredBundles", this.getRequiredBundles());
        }
        try {
            return new CompositeDataSupport(computeBundleType, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle open data", e);
        }
    }

    public static TabularData tableFrom(List<OSGiBundle> bundles, int mask) throws IOException {
        CompositeType computeBundleType = OSGiBundle.computeBundleType(mask);
        TabularDataSupport table = new TabularDataSupport(Item.tabularType((String)"BUNDLES", (String)"A list of bundles", (CompositeType)computeBundleType, (String[])new String[]{"Identifier"}));
        for (OSGiBundle bundle : bundles) {
            table.put(bundle.asCompositeData(computeBundleType, mask));
        }
        return table;
    }

    private static CompositeType computeBundleType(int mask) {
        ArrayList<Item> bundleTypeItems = new ArrayList<Item>();
        bundleTypeItems.add(BundleStateMBean.IDENTIFIER_ITEM);
        if ((mask | 1) == mask) {
            bundleTypeItems.add(BundleStateMBean.LOCATION_ITEM);
        }
        if ((mask | 4) == mask) {
            bundleTypeItems.add(BundleStateMBean.SYMBOLIC_NAME_ITEM);
        }
        if ((mask | 8) == mask) {
            bundleTypeItems.add(BundleStateMBean.VERSION_ITEM);
        }
        if ((mask | 0x10) == mask) {
            bundleTypeItems.add(BundleStateMBean.START_LEVEL_ITEM);
        }
        if ((mask | 0x20) == mask) {
            bundleTypeItems.add(BundleStateMBean.STATE_ITEM);
        }
        if ((mask | 0x40) == mask) {
            bundleTypeItems.add(BundleStateMBean.LAST_MODIFIED_ITEM);
        }
        if ((mask | 0x80) == mask) {
            bundleTypeItems.add(BundleStateMBean.PERSISTENTLY_STARTED_ITEM);
        }
        if ((mask | 0x100000) == mask) {
            bundleTypeItems.add(CustomBundleStateMBean.ACTIVATION_POLICY_ITEM);
        }
        if ((mask | 0x100) == mask) {
            bundleTypeItems.add(BundleStateMBean.REMOVAL_PENDING_ITEM);
        }
        if ((mask | 0x200) == mask) {
            bundleTypeItems.add(BundleStateMBean.REQUIRED_ITEM);
        }
        if ((mask | 0x400) == mask) {
            bundleTypeItems.add(BundleStateMBean.FRAGMENT_ITEM);
        }
        if ((mask | 0x800) == mask) {
            bundleTypeItems.add(BundleStateMBean.REGISTERED_SERVICES_ITEM);
        }
        if ((mask | 0x1000) == mask) {
            bundleTypeItems.add(BundleStateMBean.SERVICES_IN_USE_ITEM);
        }
        if ((mask | 0x2000) == mask) {
            bundleTypeItems.add(BundleStateMBean.HEADERS_ITEM);
        }
        if ((mask | 0x4000) == mask) {
            bundleTypeItems.add(BundleStateMBean.EXPORTED_PACKAGES_ITEM);
        }
        if ((mask | 0x8000) == mask) {
            bundleTypeItems.add(BundleStateMBean.IMPORTED_PACKAGES_ITEM);
        }
        if ((mask | 0x10000) == mask) {
            bundleTypeItems.add(BundleStateMBean.FRAGMENTS_ITEM);
        }
        if ((mask | 0x20000) == mask) {
            bundleTypeItems.add(BundleStateMBean.HOSTS_ITEM);
        }
        if ((mask | 0x40000) == mask) {
            bundleTypeItems.add(BundleStateMBean.REQUIRING_BUNDLES_ITEM);
        }
        if ((mask | 0x80000) == mask) {
            bundleTypeItems.add(BundleStateMBean.REQUIRED_BUNDLES_ITEM);
        }
        CompositeType currentCompositeType = Item.compositeType((String)"BUNDLE", (String)"This type encapsulates OSGi bundles", (Item[])bundleTypeItems.toArray(new Item[0]));
        return currentCompositeType;
    }

    private CompositeData asCompositeData(CompositeType computeBundleType, int mask) throws IOException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.getIdentifier());
        if ((mask | 1) == mask) {
            items.put("Location", this.getLocation());
        }
        if ((mask | 4) == mask) {
            items.put("SymbolicName", this.getSymbolicName());
        }
        if ((mask | 8) == mask) {
            items.put("Version", this.getVersion());
        }
        if ((mask | 0x10) == mask) {
            items.put("StartLevel", this.getStartLevel());
        }
        if ((mask | 0x20) == mask) {
            items.put("State", this.getState());
        }
        if ((mask | 0x40) == mask) {
            items.put("LastModified", this.getLastModified());
        }
        if ((mask | 0x80) == mask) {
            items.put("PersistentlyStarted", this.isPersistentlyStarted());
        }
        if ((mask | 0x100000) == mask) {
            items.put("ActivationPolicyUsed", this.isActivationPolicyUsed());
        }
        if ((mask | 0x100) == mask) {
            items.put("RemovalPending", this.isRemovalPending());
        }
        if ((mask | 0x200) == mask) {
            items.put("Required", this.isRequired());
        }
        if ((mask | 0x400) == mask) {
            items.put("Fragment", this.isFragment());
        }
        if ((mask | 0x800) == mask) {
            items.put("RegisteredServices", this.getRegisteredServices());
        }
        if ((mask | 0x1000) == mask) {
            items.put("ServicesInUse", this.getServicesInUse());
        }
        if ((mask | 0x2000) == mask) {
            items.put("Headers", OSGiBundle.headerTable(this.getHeaders()));
        }
        if ((mask | 0x4000) == mask) {
            items.put("ExportedPackages", this.getExportedPackages());
        }
        if ((mask | 0x8000) == mask) {
            items.put("ImportedPackages", this.getImportedPackages());
        }
        if ((mask | 0x10000) == mask) {
            items.put("Fragments", this.getFragments());
        }
        if ((mask | 0x20000) == mask) {
            items.put("Hosts", this.getHosts());
        }
        if ((mask | 0x40000) == mask) {
            items.put("RequiringBundles", this.getRequiringBundles());
        }
        if ((mask | 0x80000) == mask) {
            items.put("RequiredBundles", this.getRequiredBundles());
        }
        try {
            return new CompositeDataSupport(computeBundleType, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle open data", e);
        }
    }

    public CompositeData asCompositeData() throws IOException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.getIdentifier());
        items.put("Location", this.getLocation());
        items.put("SymbolicName", this.getSymbolicName());
        items.put("Version", this.getVersion());
        items.put("StartLevel", this.getStartLevel());
        items.put("State", this.getState());
        items.put("LastModified", this.getLastModified());
        items.put("PersistentlyStarted", this.isPersistentlyStarted());
        items.put("ActivationPolicyUsed", this.isActivationPolicyUsed());
        items.put("RemovalPending", this.isRemovalPending());
        items.put("Required", this.isRequired());
        items.put("Fragment", this.isFragment());
        items.put("RegisteredServices", this.getRegisteredServices());
        items.put("ServicesInUse", this.getServicesInUse());
        items.put("Headers", OSGiBundle.headerTable(this.getHeaders()));
        items.put("ExportedPackages", this.getExportedPackages());
        items.put("ImportedPackages", this.getImportedPackages());
        items.put("Fragments", this.getFragments());
        items.put("Hosts", this.getHosts());
        items.put("RequiringBundles", this.getRequiringBundles());
        items.put("RequiredBundles", this.getRequiredBundles());
        try {
            return new CompositeDataSupport(CustomBundleStateMBean.CUSTOM_BUNDLE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle open data", e);
        }
    }

    public static TabularData headerTable(Dictionary<String, String> headersDictionary) {
        TabularDataSupport table = new TabularDataSupport(BundleStateMBean.HEADERS_TYPE);
        Enumeration<String> headers = headersDictionary.keys();
        while (headers.hasMoreElements()) {
            String key = headers.nextElement();
            table.put(OSGiBundle.getHeaderCompositeData(key, headersDictionary.get(key)));
        }
        return table;
    }

    public static CompositeData getHeaderCompositeData(String key, String value) {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("Key", key);
        items.put("Value", value);
        try {
            return new CompositeDataSupport(BundleStateMBean.HEADER_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle header open data", e);
        }
    }

    private String[] getExportedPackages() {
        return BundleUtil.getBundleExportedPackages(this.bundle);
    }

    private Dictionary<String, String> getHeaders() {
        return this.bundle.getHeaders();
    }

    private Long[] getFragments() {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new Long[0];
        }
        List providedWires = wiring.getProvidedWires("osgi.wiring.host");
        return OSGiBundle.bundleWiresToRequirerIds(providedWires);
    }

    private Long[] getHosts() {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new Long[0];
        }
        List requiredWires = wiring.getRequiredWires("osgi.wiring.host");
        return OSGiBundle.bundleWiresToProviderIds(requiredWires);
    }

    private long getIdentifier() {
        return this.bundle.getBundleId();
    }

    private String[] getImportedPackages() {
        return BundleUtil.getBundleImportedPackages(this.bundle);
    }

    private long getLastModified() {
        return this.bundle.getLastModified();
    }

    private String getLocation() {
        return this.bundle.getLocation();
    }

    private Long[] getRegisteredServices() {
        return OSGiBundle.serviceIds(this.bundle.getRegisteredServices());
    }

    private Long[] getRequiredBundles() throws IOException {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new Long[0];
        }
        List requiredWires = wiring.getRequiredWires("osgi.wiring.bundle");
        return OSGiBundle.bundleWiresToProviderIds(requiredWires);
    }

    private Long[] getRequiringBundles() throws IOException {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new Long[0];
        }
        List providedWires = wiring.getProvidedWires("osgi.wiring.bundle");
        return OSGiBundle.bundleWiresToRequirerIds(providedWires);
    }

    private Long[] getServicesInUse() {
        return OSGiBundle.serviceIds(this.bundle.getServicesInUse());
    }

    private int getStartLevel() {
        return BundleUtil.getBundleStartLevel(this.bundle);
    }

    private String getState() {
        return BundleUtil.getBundleState(this.bundle);
    }

    private String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    private String getVersion() {
        return this.bundle.getVersion().toString();
    }

    private boolean isFragment() {
        return BundleUtil.isBundleFragment(this.bundle);
    }

    private boolean isPersistentlyStarted() {
        return BundleUtil.isBundlePersistentlyStarted(this.bundle);
    }

    private boolean isActivationPolicyUsed() {
        return BundleUtil.isBundleActivationPolicyUsed(this.bundle);
    }

    private boolean isRemovalPending() {
        return BundleUtil.isRemovalPending(this.bundle);
    }

    private boolean isRequired() {
        return BundleUtil.isRequired(this.bundle);
    }

    public static Long[] bundleWiresToRequirerIds(List<BundleWire> wires) {
        Long[] requirerIds = new Long[wires.size()];
        int i = 0;
        for (BundleWire bundleWire : wires) {
            requirerIds[i] = bundleWire.getRequirerWiring().getBundle().getBundleId();
            ++i;
        }
        return requirerIds;
    }

    public static Long[] bundleWiresToProviderIds(List<BundleWire> wires) {
        Long[] providerIds = new Long[wires.size()];
        int i = 0;
        for (BundleWire bundleWire : wires) {
            providerIds[i] = bundleWire.getProviderWiring().getBundle().getBundleId();
            ++i;
        }
        return providerIds;
    }

    public static Long[] serviceIds(ServiceReference<?>[] refs) {
        if (refs == null) {
            return new Long[0];
        }
        Long[] ids = new Long[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = (Long)refs[i].getProperty("service.id");
            ++i;
        }
        return ids;
    }
}

