/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.environment.internal;

import java.util.Arrays;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallLog;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.Level;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardInstallLog
implements InstallLog {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventLogger eventLogger;
    private final InstallArtifact installArtifact;

    public StandardInstallLog(EventLogger eventLogger, InstallArtifact installArtifact) {
        this.eventLogger = eventLogger;
        this.installArtifact = installArtifact;
    }

    @Override
    public void log(Object source, String message, String ... arguments) {
        this.doLog(source, message, arguments);
    }

    public void log(LogEvent event, Object ... inserts) {
        this.eventLogger.log(event, inserts);
        this.doLog(event, "event log message issued", this.stringify(inserts));
    }

    public void log(String code, Level level, Object ... inserts) {
        throw new UnsupportedOperationException();
    }

    public void log(String code, Level level, Throwable throwable, Object ... inserts) {
        throw new UnsupportedOperationException();
    }

    public void log(LogEvent event, Throwable throwable, Object ... inserts) {
        this.eventLogger.log(event, throwable, inserts);
        String[] stringInserts = new String[inserts.length + 1];
        stringInserts[0] = throwable.getMessage();
        System.arraycopy(this.stringify(inserts), 0, stringInserts, 1, inserts.length);
        this.doLog(event, "event log message issued", stringInserts);
    }

    private void doLog(Object source, String message, String ... arguments) {
        Object[] stringInserts = new String[arguments.length + 1];
        stringInserts[arguments.length] = source.toString();
        System.arraycopy(arguments, 0, stringInserts, 0, arguments.length);
        this.logger.debug(String.valueOf(message) + " (source '{}')", (Object)Arrays.toString(stringInserts));
    }

    private String[] stringify(Object[] inserts) {
        String[] strings = new String[inserts.length];
        int i = 0;
        while (i < inserts.length) {
            strings[i] = inserts[i] != null ? inserts[i].toString() : null;
            ++i;
        }
        return strings;
    }

    @Override
    public void logFailure(LogEvent logEvent, Throwable cause, Object ... insert) {
        this.eventLogger.log(logEvent, cause, new Object[]{this.installArtifact.getType(), this.installArtifact.getName(), this.installArtifact.getVersion(), insert});
    }
}

