/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal.ovf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.config.internal.ovf.OvfEnvironmentPropertiesReader;
import org.eclipse.virgo.nano.diagnostics.KernelLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.BundleContext;

public final class OvfPropertiesSource
implements PropertiesSource {
    static final String FRAMEWORK_PROPERTY_OVF = "org.eclipse.virgo.nano.config.ovf";
    private static final String PROPERTY_PREFIX = "cm:";
    private static final String PROPERTY_DELIMITER = ":";
    private final BundleContext bundleContext;
    private final EventLogger eventLogger;

    public OvfPropertiesSource(BundleContext bundleContext, EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.bundleContext = bundleContext;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, Properties> getConfigurationProperties() {
        try {
            Properties sourceProperties = this.readSourceProperties();
            if (sourceProperties != null) {
                return this.translateProperties(sourceProperties);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Map<String, Properties> translateProperties(Properties sourceProperties) {
        try {
            HashMap<String, Properties> result = new HashMap<String, Properties>();
            Set<String> propertyNames = sourceProperties.stringPropertyNames();
            for (String propertyName : propertyNames) {
                ConfigAdminProperty prop = this.tryReadConfigAdminProperty(propertyName);
                if (prop == null) continue;
                Properties p = (Properties)result.get(prop.pid);
                if (p == null) {
                    p = new Properties();
                    result.put(prop.pid, p);
                }
                p.setProperty(prop.key, sourceProperties.getProperty(propertyName));
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ConfigAdminProperty tryReadConfigAdminProperty(String propertyName) {
        try {
            ConfigAdminProperty result = null;
            if (propertyName.startsWith(PROPERTY_PREFIX)) {
                String parsed = propertyName.substring(PROPERTY_PREFIX.length());
                String[] components = parsed.split(PROPERTY_DELIMITER);
                if (components.length != 2) {
                    throw new IllegalArgumentException("Invalid configuration admin property '" + propertyName + "' found in OVF.");
                }
                result = new ConfigAdminProperty(null);
                result.pid = components[0];
                result.key = components[1];
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties readSourceProperties() {
        try {
            Properties result = null;
            File ovfFile = this.determineOvfFile();
            if (ovfFile != null) {
                if (!ovfFile.exists()) {
                    this.eventLogger.log((LogEvent)KernelLogEvents.OVF_CONFIGURATION_FILE_DOES_NOT_EXIST, new Object[]{ovfFile.getAbsolutePath()});
                } else {
                    result = this.readOvfFile(ovfFile);
                }
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private File determineOvfFile() {
        try {
            File result = null;
            String path = this.bundleContext.getProperty(FRAMEWORK_PROPERTY_OVF);
            if (path != null) {
                result = new File(path);
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties readOvfFile(File ovfFile) {
        try {
            Properties result = null;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(ovfFile), StandardCharsets.UTF_8);){
                    OvfEnvironmentPropertiesReader ovfReader = new OvfEnvironmentPropertiesReader();
                    result = ovfReader.readProperties(reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                this.eventLogger.log((LogEvent)KernelLogEvents.OVF_READ_ERROR, (Throwable)ex, new Object[]{ovfFile.getAbsolutePath()});
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static class ConfigAdminProperty {
        String pid;
        String key;

        private ConfigAdminProperty() {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ ConfigAdminProperty(ConfigAdminProperty configAdminProperty) {
            ConfigAdminProperty ajc$aspectInstance = this;
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

