/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.cacheing.cache;

import java.io.File;
import java.net.URI;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.RepositoryCreationException;
import org.eclipse.virgo.repository.internal.cacheing.cache.RepositoryCache;
import org.eclipse.virgo.repository.internal.cacheing.cache.artifact.SingleArtifactCache;
import org.eclipse.virgo.repository.internal.cacheing.cache.artifact.SingleArtifactCacheFactory;
import org.eclipse.virgo.repository.internal.cacheing.cache.descriptorhash.ArtifactDescriptorHash;
import org.eclipse.virgo.repository.internal.cacheing.cache.descriptorhash.ArtifactDescriptorHashFactory;
import org.eclipse.virgo.util.common.Assert;

final class StandardRepositoryCache
implements RepositoryCache {
    private final String repositoryName;
    private final File repositoryCacheDirectory;
    private final SingleArtifactCacheFactory artifactCacheFactory;
    private final ArtifactDescriptorHashFactory artifactDescriptorHashFactory;

    StandardRepositoryCache(String repositoryName, File cacheDirectory, SingleArtifactCacheFactory artifactCacheFactory, ArtifactDescriptorHashFactory artifactDescriptorHashFactory) {
        Assert.notNull((Object)repositoryName, (String)"repository name must not be null", (Object[])new Object[0]);
        this.repositoryName = repositoryName;
        this.repositoryCacheDirectory = StandardRepositoryCache.createRepositoryCacheDirectory(repositoryName, cacheDirectory);
        this.artifactCacheFactory = artifactCacheFactory;
        this.artifactDescriptorHashFactory = artifactDescriptorHashFactory;
    }

    private static File createRepositoryCacheDirectory(String repositoryName, File cacheDirectory) {
        File dir = new File(cacheDirectory, repositoryName);
        if (dir.exists()) {
            if (dir.isFile()) {
                throw new RuntimeException(new RepositoryCreationException("Repository cache directory " + dir.getPath() + " cannot be created as there is a file at that location"));
            }
        } else if (!dir.mkdirs()) {
            throw new RuntimeException(new RepositoryCreationException("Error creating repository cache directory " + dir.getPath()));
        }
        return dir;
    }

    @Override
    public URI getUri(RepositoryAwareArtifactDescriptor artifactDescriptor) {
        this.checkRepositoryName(artifactDescriptor);
        SingleArtifactCache artifactDescriptorCache = this.getArtifactCache(artifactDescriptor);
        return artifactDescriptorCache.getCachedUri(this.createArtifactDescriptorHash(artifactDescriptor));
    }

    private void checkRepositoryName(RepositoryAwareArtifactDescriptor artifactDescriptor) {
        Assert.isTrue((boolean)this.repositoryName.equals(artifactDescriptor.getRepositoryName()), (String)"Wrong RepositoryCache for the given artifact descriptor", (Object[])new Object[0]);
    }

    private ArtifactDescriptorHash createArtifactDescriptorHash(RepositoryAwareArtifactDescriptor artifactDescriptor) {
        return this.artifactDescriptorHashFactory.createArtifactDescriptorHash(artifactDescriptor);
    }

    private SingleArtifactCache getArtifactCache(RepositoryAwareArtifactDescriptor artifactDescriptor) {
        return this.artifactCacheFactory.getArtifactCache(artifactDescriptor, this.repositoryCacheDirectory);
    }
}

