/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.event;

import java.util.Set;
import org.eclipse.virgo.kernel.deployer.core.event.ApplicationBundleDeploymentEvent;
import org.eclipse.virgo.kernel.deployer.core.event.ApplicationDeploymentEvent;
import org.eclipse.virgo.kernel.deployer.core.event.DeploymentListener;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApplicationDeploymentEventNotifier
implements DeploymentListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<DeploymentListener> listeners;

    ApplicationDeploymentEventNotifier(Set<DeploymentListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void onEvent(ApplicationDeploymentEvent event) {
        Bundle bundle = null;
        if (event instanceof ApplicationBundleDeploymentEvent) {
            bundle = ((ApplicationBundleDeploymentEvent)event).getBundle();
        }
        if (bundle == null) {
            this.logger.info("Delivering '{}' for application '{}' version '{}' to application deployment listeners", new Object[]{event.getClass().getName(), event.getApplicationSymbolicName(), event.getApplicationVersion()});
        } else {
            this.logger.info("Delivering '{}' for bundle '{}' of application '{}' version '{}' to application deployment listeners", new Object[]{event.getClass().getName(), bundle.getSymbolicName(), event.getApplicationSymbolicName(), event.getApplicationVersion()});
        }
        for (DeploymentListener listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (RuntimeException e) {
                this.logger.error("Application deployment listener '{}' threw exception", (Object)e, (Object)listener);
            }
        }
        if (bundle == null) {
            this.logger.info("Delivered '{}' for application '%s' version '{}' to application deployment listeners", new Object[]{event.getClass().getName(), event.getApplicationSymbolicName(), event.getApplicationVersion()});
        } else {
            this.logger.info("Delivered '{}' for bundle '{}' of application '{}' version '{}' to application deployment listeners", new Object[]{event.getClass().getName(), bundle.getSymbolicName(), event.getApplicationSymbolicName(), event.getApplicationVersion()});
        }
    }
}

