/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import org.jolokia.backend.MBeanServers;
import org.jolokia.backend.executor.AbstractMBeanServerExecutor;
import org.jolokia.backend.executor.NotChangedException;
import org.jolokia.detector.ServerDetector;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerExecutorLocal
extends AbstractMBeanServerExecutor
implements NotificationListener {
    private MBeanServers mbeanServers;

    public MBeanServerExecutorLocal(List<ServerDetector> pDetectors) {
        this.init(pDetectors);
    }

    public MBeanServerExecutorLocal() {
        this(Collections.emptyList());
    }

    private synchronized void init(List<ServerDetector> pDetectors) {
        this.mbeanServers = new MBeanServers(pDetectors, this);
        this.registerForMBeanNotifications();
    }

    public <R extends JmxRequest> Object handleRequest(JsonRequestHandler<R> pRequestHandler, R pJmxReq) throws MBeanException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, NotChangedException {
        AttributeNotFoundException attrException = null;
        InstanceNotFoundException objNotFoundException = null;
        for (MBeanServerConnection conn : this.getMBeanServers()) {
            try {
                return pRequestHandler.handleRequest(conn, pJmxReq);
            }
            catch (InstanceNotFoundException exp) {
                objNotFoundException = exp;
            }
            catch (AttributeNotFoundException exp) {
                attrException = exp;
            }
            catch (IOException exp) {
                throw new IllegalStateException("I/O Error while dispatching", exp);
            }
        }
        if (attrException != null) {
            throw attrException;
        }
        throw objNotFoundException;
    }

    public void destroy() {
        this.unregisterFromMBeanNotifications();
        this.mbeanServers.destroy();
    }

    public String getServersInfo() {
        return this.mbeanServers.dump();
    }

    @Override
    protected Set<MBeanServerConnection> getMBeanServers() {
        return this.mbeanServers.getMBeanServers();
    }

    @Override
    protected MBeanServerConnection getJolokiaMBeanServer() {
        return this.mbeanServers.getJolokiaMBeanServer();
    }
}

