/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loader;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.eclipse.gemini.web.tomcat.internal.loader.BaseWebappLoader;
import org.eclipse.gemini.web.tomcat.internal.loader.BundleWebappClassLoader;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWebappLoader
extends BaseWebappLoader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile Bundle bundle;
    private volatile ClassLoaderCustomizer classLoaderCustomizer;
    private long bundleModificationCheckTimestamp;
    private final Object bundleModificationLock = new Object();
    private BundleWebappClassLoader classLoader = null;

    public BundleWebappLoader(Bundle bundle, ClassLoaderCustomizer classLoaderCustomizer) {
        this.bundle = bundle;
        this.bundleModificationCheckTimestamp = this.bundle.getLastModified();
        this.classLoaderCustomizer = classLoaderCustomizer;
    }

    private BundleWebappClassLoader createClassLoader() {
        return new BundleWebappClassLoader(this.bundle, this.classLoaderCustomizer);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modified() {
        Object object = this.bundleModificationLock;
        synchronized (object) {
            block4: {
                long lastModified = this.bundle.getLastModified();
                if (lastModified <= this.bundleModificationCheckTimestamp) break block4;
                this.bundleModificationCheckTimestamp = lastModified;
                return true;
            }
        }
        return false;
    }

    public void startInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting this loader.");
        }
        if (this.getContext().getResources() == null) {
            this.log.info("No resources for [" + this.getContext() + "].");
            this.setState(LifecycleState.STARTING);
            return;
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.start();
            this.registerClassLoaderMBean();
        }
        catch (Throwable t) {
            t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log.error("LifecycleException ", t);
            throw new LifecycleException("start: ", t);
        }
        this.setState(LifecycleState.STARTING);
    }

    public void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping this loader.");
        }
        this.setState(LifecycleState.STOPPING);
        ServletContext servletContext = this.getContext().getServletContext();
        servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        try {
            this.classLoader.stop();
        }
        finally {
            this.classLoader.destroy();
        }
        this.unregisterClassLoaderMBean();
        this.classLoader = null;
        this.bundle = null;
        this.classLoaderCustomizer = null;
    }

    private void registerClassLoaderMBean() throws MalformedObjectNameException, Exception {
        ObjectName classLoaderObjectName = this.createClassLoaderObjectName(this.getContext());
        Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, classLoaderObjectName, null);
    }

    private void unregisterClassLoaderMBean() {
        try {
            ObjectName classLoaderObjectName = this.createClassLoaderObjectName(this.getContext());
            Registry.getRegistry(null, null).unregisterComponent(classLoaderObjectName);
        }
        catch (Throwable t) {
            this.log.error("LifecycleException ", t);
        }
    }

    private ObjectName createClassLoaderObjectName(Context ctx) throws MalformedObjectNameException {
        return new ObjectName(String.valueOf(ctx.getDomain()) + ":type=" + this.classLoader.getClass().getSimpleName() + ",host=" + ctx.getParent().getName() + ",context=" + this.getCatalinaContextPath(ctx));
    }
}

