/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.management.controller;

import org.eclipse.virgo.nano.core.KernelConfig;
import org.eclipse.virgo.nano.deployer.api.Deployer;
import org.eclipse.virgo.nano.deployer.api.RecoveryMonitor;
import org.eclipse.virgo.nano.management.DefaultManagementExporter;
import org.osgi.framework.BundleContext;

public class NanoManagementController {
    private Deployer deployerMBean;
    private RecoveryMonitor recoveryMonitorMBean;
    private KernelConfig kernelConfig;
    private DefaultManagementExporter<Deployer> deployerMBeanExporter;
    private DefaultManagementExporter<RecoveryMonitor> recoveryMBeanExporter;

    public void activate(BundleContext context) {
        String domainProperty = this.kernelConfig.getProperty("domain");
        this.deployerMBeanExporter = new DefaultManagementExporter((Object)this.deployerMBean, String.valueOf(domainProperty) + ":category=Control,type=Deployer");
        this.deployerMBeanExporter.export();
        this.recoveryMBeanExporter = new DefaultManagementExporter((Object)this.recoveryMonitorMBean, String.valueOf(domainProperty) + ":category=Control,type=RecoveryMonitor");
        this.recoveryMBeanExporter.export();
    }

    public void deactivate(BundleContext context) {
        this.deployerMBeanExporter.unExport();
        this.recoveryMBeanExporter.unExport();
    }

    public void bindDeployerMBean(Deployer deployer) {
        this.deployerMBean = deployer;
    }

    public void unbindDeployerMBean(Deployer deployer) {
        this.deployerMBean = null;
    }

    public void bindRecoveryMBean(RecoveryMonitor recovery) {
        this.recoveryMonitorMBean = recovery;
    }

    public void unbindRecoveryMBean(RecoveryMonitor recovery) {
        this.recoveryMonitorMBean = null;
    }

    public void bindKernelConfig(KernelConfig config) {
        this.kernelConfig = config;
    }

    public void unbindKernelConfig(KernelConfig config) {
        this.kernelConfig = null;
    }
}

