/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.config.internal.KernelConfiguration;
import org.eclipse.virgo.nano.core.FatalKernelException;
import org.eclipse.virgo.nano.core.Shutdown;
import org.eclipse.virgo.nano.core.internal.BundleStartTracker;
import org.eclipse.virgo.nano.core.internal.KernelStatus;
import org.eclipse.virgo.nano.core.internal.ServiceReferenceTracker;
import org.eclipse.virgo.nano.diagnostics.KernelLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StartupTracker {
    private static final String THREAD_NAME_STARTUP_TRACKER = "startup-tracker";
    static final String APPLICATION_CONTEXT_FILTER = "(objectClass=org.springframework.context.ApplicationContext)";
    private static final String KERNEL_EVENT_TOPIC = "org/eclipse/virgo/kernel/";
    private static final String KERNEL_EVENT_STARTING = "org/eclipse/virgo/kernel/STARTING";
    private static final String KERNEL_EVENT_STARTED = "org/eclipse/virgo/kernel/STARTED";
    private static final String KERNEL_EVENT_START_TIMED_OUT = "org/eclipse/virgo/kernel/START_TIMED_OUT";
    private static final String KERNEL_EVENT_START_ABORTED = "org/eclipse/virgo/kernel/START_ABORTED";
    private static final String KERNEL_EVENT_START_FAILED = "org/eclipse/virgo/kernel/START_FAILED";
    private static final String KERNEL_BSN_PREFIX = "org.eclipse.virgo.kernel";
    private static final String NANO_CORE_BSN_PREFIX = "org.eclipse.virgo.nano.core";
    private static final String NANO_AUTH_BSN_PREFIX = "org.eclipse.virgo.nano.authentication";
    private static final Logger LOGGER = LoggerFactory.getLogger(StartupTracker.class);
    private final KernelStatus status;
    private final KernelConfiguration configuration;
    private final Thread startupTrackingThread;
    private volatile ObjectInstance statusInstance;

    StartupTracker(BundleContext context, KernelConfiguration configuration, int startupWaitTime, BundleStartTracker asyncBundleStartTracker, Shutdown shutdown, DumpGenerator dumpGenerator) {
        try {
            this.status = new KernelStatus();
            StartupTrackingRunnable startupTrackingRunnable = new StartupTrackingRunnable(context, startupWaitTime, asyncBundleStartTracker, this.status, shutdown, dumpGenerator, null);
            this.startupTrackingThread = new Thread((Runnable)startupTrackingRunnable, THREAD_NAME_STARTUP_TRACKER);
            this.configuration = configuration;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void start() {
        try {
            this.registerKernelStatusMBean();
            this.startupTrackingThread.start();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void stop() {
        try {
            this.unregisterKernelStatusMBean();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void registerKernelStatusMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = ObjectName.getInstance(this.configuration.getDomain(), "type", "KernelStatus");
                this.statusInstance = server.registerMBean(this.status, name);
            }
            catch (JMException e) {
                throw new FatalKernelException("Unable to register KernelStatus MBean", e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void unregisterKernelStatusMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectInstance instance = this.statusInstance;
                if (instance != null && server.isRegistered(instance.getObjectName())) {
                    server.unregisterMBean(this.statusInstance.getObjectName());
                }
            }
            catch (JMException e) {
                throw new FatalKernelException("Unable to unregister KernelStatus MBean", e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Logger access$0() {
        try {
            return LOGGER;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final class StartupTrackingRunnable
    implements Runnable {
        private final BundleContext context;
        private final int startupWaitTime;
        private final BundleStartTracker asyncBundleStartTracker;
        private final KernelStatus kernelStatus;
        private final Shutdown shutdown;
        private final DumpGenerator dumpGenerator;
        private final ServiceReferenceTracker serviceReferenceTracker;
        private EventLogger eventLogger;
        private EventAdmin eventAdmin;

        private StartupTrackingRunnable(BundleContext context, int startupWaitTime, BundleStartTracker asyncBundleStartTracker, KernelStatus kernelStatus, Shutdown shutdown, DumpGenerator dumpGenerator) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.eventLogger = null;
                this.eventAdmin = null;
                this.context = context;
                this.startupWaitTime = startupWaitTime;
                this.asyncBundleStartTracker = asyncBundleStartTracker;
                this.kernelStatus = kernelStatus;
                this.shutdown = shutdown;
                this.dumpGenerator = dumpGenerator;
                this.serviceReferenceTracker = new ServiceReferenceTracker(context);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 12[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private EventLogger getEventLoggerService() {
            try {
                EventLogger eventLogger = null;
                ServiceReference eventLoggerServiceReference = this.context.getServiceReference(EventLogger.class.getName());
                if (eventLoggerServiceReference != null) {
                    eventLogger = (EventLogger)this.context.getService(this.serviceReferenceTracker.track(eventLoggerServiceReference));
                }
                return eventLogger;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private EventAdmin getEventAdminService() {
            try {
                EventAdmin eventAdmin = null;
                ServiceReference eventAdminServiceReference = this.context.getServiceReference(EventAdmin.class.getName());
                if (eventAdminServiceReference != null) {
                    eventAdmin = (EventAdmin)this.context.getService(this.serviceReferenceTracker.track(eventAdminServiceReference));
                }
                return eventAdmin;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private boolean isKernelBundle(Bundle bundle) {
            try {
                String symbolicName = bundle.getSymbolicName();
                return symbolicName != null && (symbolicName.startsWith(StartupTracker.KERNEL_BSN_PREFIX) || symbolicName.startsWith(StartupTracker.NANO_AUTH_BSN_PREFIX) || symbolicName.startsWith(StartupTracker.NANO_CORE_BSN_PREFIX));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void kernelStarting() {
            try {
                this.postEvent(StartupTracker.KERNEL_EVENT_STARTING);
                this.logEvent(KernelLogEvents.KERNEL_STARTING, new Object[0]);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void kernelStarted() {
            try {
                this.kernelStatus.setStarted();
                this.postEvent(StartupTracker.KERNEL_EVENT_STARTED);
                this.logEvent(KernelLogEvents.KERNEL_STARTED, new Object[0]);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void kernelStartAborted(Bundle bundle) {
            try {
                this.postEvent(StartupTracker.KERNEL_EVENT_START_ABORTED);
                this.logEvent(KernelLogEvents.KERNEL_EVENT_START_ABORTED, bundle.getSymbolicName(), bundle.getVersion());
                this.generateDumpAndShutdown("startupTimedOut", null);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void kernelStartTimedOut() {
            try {
                this.postEvent(StartupTracker.KERNEL_EVENT_START_TIMED_OUT);
                this.logEvent(KernelLogEvents.KERNEL_START_TIMED_OUT, this.startupWaitTime);
                this.generateDumpAndShutdown("startupTimedOut", null);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void kernelStartFailed(Throwable failure) {
            try {
                this.postEvent(StartupTracker.KERNEL_EVENT_START_FAILED);
                this.logEvent(KernelLogEvents.KERNEL_START_FAILED, failure, new Object[0]);
                this.generateDumpAndShutdown("startupFailed", failure);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void generateDumpAndShutdown(String cause, Throwable failure) {
            try {
                if (failure != null) {
                    this.dumpGenerator.generateDump(cause, new Throwable[]{failure});
                } else {
                    this.dumpGenerator.generateDump(cause, new Throwable[0]);
                }
                this.shutdown.immediateShutdown();
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void logEvent(KernelLogEvents event, Throwable throwable, Object ... args) {
            try {
                if (this.eventLogger != null) {
                    this.eventLogger.log((LogEvent)event, throwable, args);
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void logEvent(KernelLogEvents event, Object ... args) {
            try {
                this.logEvent(event, null, args);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private void postEvent(String topic) {
            try {
                if (this.eventAdmin != null) {
                    this.eventAdmin.postEvent(new Event(topic, null));
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ StartupTrackingRunnable(BundleContext bundleContext, int n, BundleStartTracker bundleStartTracker, KernelStatus kernelStatus, Shutdown shutdown, DumpGenerator dumpGenerator, StartupTrackingRunnable startupTrackingRunnable) {
            DumpGenerator dumpGenerator2 = dumpGenerator;
            Shutdown shutdown2 = shutdown;
            KernelStatus kernelStatus2 = kernelStatus;
            BundleStartTracker bundleStartTracker2 = bundleStartTracker;
            int n2 = n;
            BundleContext bundleContext2 = bundleContext;
            StartupTrackingRunnable ajc$aspectInstance = this;
            try {
                void dumpGenerator3;
                void shutdown3;
                void kernelStatus3;
                void asyncBundleStartTracker;
                void startupWaitTime;
                void context;
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ajc$aspectInstance.eventLogger = null;
                ajc$aspectInstance.eventAdmin = null;
                ajc$aspectInstance.context = context;
                ajc$aspectInstance.startupWaitTime = startupWaitTime;
                ajc$aspectInstance.asyncBundleStartTracker = asyncBundleStartTracker;
                ajc$aspectInstance.kernelStatus = kernelStatus3;
                ajc$aspectInstance.shutdown = shutdown3;
                ajc$aspectInstance.dumpGenerator = dumpGenerator3;
                ajc$aspectInstance.serviceReferenceTracker = new ServiceReferenceTracker((BundleContext)context);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

