/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodReturnType;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class MethodAttributeAccessor
extends AttributeAccessor {
    protected String setMethodName = "";
    protected String getMethodName;
    protected transient Method setMethod;
    protected transient Method getMethod;

    @Override
    public Class getAttributeClass() {
        if (this.getGetMethod() == null) {
            return null;
        }
        return this.getGetMethodReturnType();
    }

    @Override
    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        return this.getAttributeValueFromObject(anObject, null);
    }

    protected Object getAttributeValueFromObject(Object anObject, Object[] parameters) throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getGetMethod(), anObject, parameters));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof IllegalAccessException) {
                        throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), throwableException);
                    }
                    throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), throwableException);
                }
            }
            return this.getMethod.invoke(anObject, parameters);
        }
        catch (IllegalArgumentException exception) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public Class getGetMethodReturnType() throws DescriptorException {
        if (this.getGetMethod() == null && this.getGetMethodName() != null && this.getGetMethodName().indexOf("_persistence_") > -1) {
            AbstractSessionLog.getLog().log(1, "no_weaved_vh_method_found_verify_weaving_and_module_order", this.getGetMethodName(), null, (Object)this);
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessorCausedByWeavingNotOccurringBecauseOfModuleOrder(this.getGetMethodName(), "", null);
        }
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedGetMethodReturnType(this.getGetMethod()));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethodReturnType(this.getGetMethod());
    }

    protected Method getSetMethod() {
        return this.setMethod;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public Class getSetMethodParameterType() {
        return this.getSetMethodParameterType(0);
    }

    protected Class getSetMethodParameterType(int index) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return ((Class[])AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(this.getSetMethod())))[index];
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethodParameterTypes(this.getSetMethod())[index];
    }

    protected Class[] getSetMethodParameterTypes() {
        return new Class[]{this.getGetMethodReturnType()};
    }

    @Override
    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.initializeAttributes(theJavaClass, null);
    }

    protected void initializeAttributes(Class theJavaClass, Class[] getParameterTypes) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setGetMethod(Helper.getDeclaredMethod(theJavaClass, this.getGetMethodName(), getParameterTypes));
            if (!this.isWriteOnly()) {
                this.setSetMethod(Helper.getDeclaredMethod(theJavaClass, this.getSetMethodName(), this.getSetMethodParameterTypes()));
            }
        }
        catch (NoSuchMethodException ex) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(ex);
            throw descriptorException;
        }
        catch (SecurityException exception) {
            DescriptorException descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(exception);
            throw descriptorException;
        }
    }

    @Override
    public boolean isInitialized() {
        return !(this.getMethod == null && !this.isReadOnly() || this.setMethod == null && !this.isWriteOnly());
    }

    @Override
    public boolean isMethodAttributeAccessor() {
        return true;
    }

    @Override
    public void setAttributeValueInObject(Object domainObject, Object attributeValue) throws DescriptorException {
        this.setAttributeValueInObject(domainObject, attributeValue, new Object[]{attributeValue});
    }

    protected void setAttributeValueInObject(Object domainObject, Object attributeValue, Object[] parameters) throws DescriptorException {
        block24: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), domainObject, parameters));
                        break block24;
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, throwableException);
                        }
                        throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, throwableException);
                    }
                }
                this.setMethod.invoke(domainObject, parameters);
            }
            catch (IllegalAccessException exception) {
                throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
            }
            catch (IllegalArgumentException exception) {
                try {
                    if (attributeValue instanceof String) {
                        Object newValue = ConversionManager.getDefaultManager().convertObject(attributeValue, this.getAttributeClass());
                        Object[] newParameters = new Object[]{newValue};
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), domainObject, newParameters));
                            }
                            catch (PrivilegedActionException privilegedActionException) {}
                        } else {
                            PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), domainObject, newParameters);
                        }
                        return;
                    }
                }
                catch (Exception exception2) {}
                throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
            }
            catch (InvocationTargetException exception) {
                throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
            }
            catch (NullPointerException exception) {
                try {
                    Class fieldClass = this.getSetMethodParameterType();
                    if (fieldClass.isPrimitive() && attributeValue == null) {
                        parameters[parameters.length - 1] = ConversionManager.getDefaultManager().convertObject(0, fieldClass);
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), domainObject, parameters));
                            }
                            catch (PrivilegedActionException exc) {
                                Exception throwableException = exc.getException();
                                if (throwableException instanceof IllegalAccessException) {
                                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, throwableException);
                                }
                                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, throwableException);
                            }
                        }
                        PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), domainObject, parameters);
                    }
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
                }
            }
        }
    }

    protected void setGetMethod(Method getMethod) {
        this.getMethod = getMethod;
    }

    public void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    protected void setSetMethod(Method setMethod) {
        this.setMethod = setMethod;
    }

    public void setSetMethodName(String setMethodName) {
        this.setMethodName = setMethodName;
    }
}

