/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import org.eclipse.virgo.kernel.deployer.core.internal.BlockingSignal;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;

public final class BlockingAbortableSignal
implements AbortableSignal {
    private final BlockingSignal blockingSignal;
    private boolean aborted = false;

    public BlockingAbortableSignal(boolean synchronous) {
        this.blockingSignal = new BlockingSignal(synchronous);
    }

    public void signalSuccessfulCompletion() {
        this.blockingSignal.signalSuccessfulCompletion();
    }

    public void signalFailure(Throwable cause) {
        this.blockingSignal.signalFailure(cause);
    }

    public void signalAborted() {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean awaitCompletion(long timeInSeconds) throws DeploymentException {
        return this.blockingSignal.awaitCompletion(timeInSeconds);
    }

    public boolean checkComplete() throws DeploymentException {
        boolean complete = this.blockingSignal.checkComplete();
        if (this.aborted) {
            return false;
        }
        return complete;
    }
}

