/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.container;

import java.util.Enumeration;
import javax.naming.OperationNotSupportedException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.eclipse.virgo.snaps.core.internal.webapp.SnapServletContext;
import org.eclipse.virgo.snaps.core.internal.webapp.container.HttpSessionWrapper;

public final class SnapHttpSession
extends HttpSessionWrapper {
    private static final String QUALIFIED_NAME_MARKER = "##";
    private final SnapServletContext snapServletContext;

    public SnapHttpSession(HttpSession delegate, SnapServletContext snapServletContext) {
        super(delegate);
        this.snapServletContext = snapServletContext;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = super.getAttribute(this.qualifyName(name));
        if (value == null) {
            value = super.getAttribute(name);
        }
        return value;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new UnqualifyingEnumerationWrapper(super.getAttributeNames());
    }

    @Override
    public void removeAttribute(String name) {
        super.removeAttribute(this.qualifyName(name));
    }

    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(this.qualifyName(name), value);
    }

    public HttpSessionContext getSessionContext() {
        throw new RuntimeException(new OperationNotSupportedException("getSessionContext is deprecated"));
    }

    private String qualifyName(String baseName) {
        return QUALIFIED_NAME_MARKER + this.snapServletContext.getSnapContextPath() + "." + baseName;
    }

    private String unqualifyName(String name) {
        int index;
        String unqualified = name;
        if (unqualified.startsWith(QUALIFIED_NAME_MARKER) && (index = unqualified.indexOf(".")) > -1) {
            unqualified = name.substring(index + 1);
        }
        return unqualified;
    }

    private final class UnqualifyingEnumerationWrapper
    implements Enumeration<String> {
        private final Enumeration<?> delegate;

        public UnqualifyingEnumerationWrapper(Enumeration<?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasMoreElements() {
            return this.delegate.hasMoreElements();
        }

        @Override
        public String nextElement() {
            String element = (String)this.delegate.nextElement();
            if (element != null) {
                element = SnapHttpSession.this.unqualifyName(element);
            }
            return element;
        }
    }
}

