/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.container;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.virgo.snaps.core.RequestRouter;
import org.eclipse.virgo.snaps.core.internal.webapp.config.FilterDispatcherType;
import org.eclipse.virgo.snaps.core.internal.webapp.container.FilterChainFactory;
import org.eclipse.virgo.snaps.core.internal.webapp.container.ServletManager;
import org.eclipse.virgo.snaps.core.internal.webapp.container.SnapHttpServletRequest;
import org.eclipse.virgo.snaps.core.internal.webapp.container.VirtualContainer;
import org.eclipse.virgo.snaps.core.internal.webapp.container.VirtualContainerRequestDispatcher;
import org.eclipse.virgo.snaps.core.internal.webapp.url.Mapping;
import org.eclipse.virgo.snaps.core.internal.webapp.url.PathTranslation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardVirtualContainerRequestDispatcher
implements VirtualContainerRequestDispatcher {
    private static final String FORWARD_REQUEST_URI_ATTRIBUTE_NAME = "javax.servlet.forward.request_uri";
    private static final String INCLUDE_SERVLET_PATH_ATTRIBUTE_NAME = "javax.servlet.include.servlet_path";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServletManager servletManager;
    private final ClassLoader classLoader;
    private final VirtualContainer virtualContainer;
    private final FilterChainFactory filterChainFactory;
    private final RequestRouter requestRouter;

    StandardVirtualContainerRequestDispatcher(ServletManager servletManager, ClassLoader classLoader, VirtualContainer virtualContainer, FilterChainFactory filterChainFactory, RequestRouter requestRouter) {
        this.servletManager = servletManager;
        this.classLoader = classLoader;
        this.virtualContainer = virtualContainer;
        this.filterChainFactory = filterChainFactory;
        this.requestRouter = requestRouter;
    }

    @Override
    public void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servicing request '{}'", (Object)request.getPathInfo());
        FilterDispatcherType requestType = FilterDispatcherType.REQUEST;
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String servletPathForMatch = (String)request.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE_NAME);
        if (servletPathForMatch == null) {
            if (request.getAttribute(FORWARD_REQUEST_URI_ATTRIBUTE_NAME) != null) {
                requestType = FilterDispatcherType.FORWARD;
            }
            servletPathForMatch = request.getServletPath();
        } else {
            requestType = FilterDispatcherType.INCLUDE;
        }
        ServletManager.Match match = this.servletManager.findMatch(servletPathForMatch);
        if (match == null) {
            response.sendError(404);
        } else {
            if (requestType != FilterDispatcherType.INCLUDE) {
                PathTranslation translation = match.getMapping().translate(servletPathForMatch);
                servletPath = translation.getServletPath();
                pathInfo = translation.getPathInfo();
            }
            final HttpServletRequest wrappedRequest = this.wrapRequest(request, servletPath, pathInfo, match.getMapping());
            final FilterChain filterChain = this.filterChainFactory.createFilterChain(servletPathForMatch, match.getServlet(), match.getMapping().getName(), requestType);
            this.doWithThreadContextClassLoader(new ClassLoaderCallback<Void>(){

                @Override
                public Void doWithClassLoader() throws ServletException, IOException {
                    filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
                    return null;
                }
            });
        }
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request, String servletPath, String pathInfo, Mapping match) {
        return new SnapHttpServletRequest(request, servletPath, pathInfo, this.virtualContainer, this.requestRouter);
    }

    private <T> T doWithThreadContextClassLoader(ClassLoaderCallback<T> callback) throws ServletException, IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.classLoader);
            T t = callback.doWithClassLoader();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    private static interface ClassLoaderCallback<T> {
        public T doWithClassLoader() throws ServletException, IOException;
    }
}

