/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.util.List;
import java.util.Map;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.osgi.framework.Version;

public class PackageMergeUtils {
    public static void mergeImportPackage(BundleManifest manifest, String name, Map<String, String> attributes, Map<String, String> directives) {
        ImportedPackage packageImport = PackageMergeUtils.findImportedPackage(manifest, name);
        if (packageImport == null) {
            packageImport = manifest.getImportPackage().addImportedPackage(name);
        }
        packageImport.getAttributes().clear();
        packageImport.getAttributes().putAll(attributes);
        packageImport.getDirectives().clear();
        packageImport.getDirectives().putAll(directives);
    }

    public static void mergeExportPackage(BundleManifest manifest, String name, Map<String, String> attributes, Map<String, String> directives) {
        String versionAttribute = attributes.get("version");
        Version version = versionAttribute == null ? Version.emptyVersion : new Version(versionAttribute);
        ExportedPackage packageExport = PackageMergeUtils.findExportedPackage(manifest, name, version);
        if (packageExport == null) {
            packageExport = manifest.getExportPackage().addExportedPackage(name);
        }
        packageExport.getAttributes().clear();
        packageExport.getAttributes().putAll(attributes);
        packageExport.getDirectives().clear();
        packageExport.getDirectives().putAll(directives);
    }

    private static final ExportedPackage findExportedPackage(BundleManifest manifest, String packageName, Version version) {
        List exportedPackages = manifest.getExportPackage().getExportedPackages();
        for (ExportedPackage exportedPackage : exportedPackages) {
            if (!packageName.equals(exportedPackage.getPackageName()) || !version.equals((Object)exportedPackage.getVersion())) continue;
            return exportedPackage;
        }
        return null;
    }

    static final ImportedPackage findImportedPackage(BundleManifest manifest, String packageName) {
        List importedPackages = manifest.getImportPackage().getImportedPackages();
        for (ImportedPackage importedPackage : importedPackages) {
            if (!packageName.equals(importedPackage.getPackageName())) continue;
            return importedPackage;
        }
        return null;
    }
}

