/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.completers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.shell.CommandCompleter;
import org.eclipse.virgo.kernel.shell.state.StateService;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public class PackageCompleter
implements CommandCompleter {
    private static final String SUBCOMMAND_LIST = "list";
    private final StateService stateService;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public PackageCompleter(StateService stateService) {
        this.stateService = stateService;
    }

    @Override
    public List<String> getCompletionCandidates(String subcommand, String ... tokens) {
        Set<Object> candidates = SUBCOMMAND_LIST.equals(subcommand) ? Collections.emptySet() : (tokens.length == 2 ? this.versions(tokens[0], tokens[1]) : (tokens.length == 1 ? this.names(tokens[0]) : Collections.emptySet()));
        ArrayList<String> candidateList = new ArrayList<String>(candidates);
        Collections.sort(candidateList);
        return candidateList;
    }

    private Set<String> versions(String name, String version) {
        try {
            PackageCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            HashSet<String> versions = new HashSet<String>();
            for (QuasiExportPackage exportPackage : this.getAllPackages()) {
                String packageName = exportPackage.getPackageName();
                String packageVersion = exportPackage.getVersion().toString();
                if (!packageName.equals(name) || !packageVersion.startsWith(version)) continue;
                versions.add(packageVersion);
            }
            HashSet<String> hashSet = versions;
            PackageCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return hashSet;
        }
        catch (Throwable throwable) {
            PackageCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Set<String> names(String name) {
        try {
            PackageCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            HashSet<String> names = new HashSet<String>();
            for (QuasiExportPackage exportPackage : this.getAllPackages()) {
                String packageName = exportPackage.getPackageName();
                if (!packageName.startsWith(name)) continue;
                names.add(packageName);
            }
            HashSet<String> hashSet = names;
            PackageCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return hashSet;
        }
        catch (Throwable throwable) {
            PackageCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private List<QuasiExportPackage> getAllPackages() {
        ArrayList<QuasiExportPackage> packages = new ArrayList<QuasiExportPackage>();
        for (QuasiBundle bundle : this.stateService.getAllBundles(null)) {
            packages.addAll(bundle.getExportPackages());
        }
        return packages;
    }

    static {
        Factory factory = new Factory("PackageCompleter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.completers.PackageCompleter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "versions", "org.eclipse.virgo.kernel.shell.internal.completers.PackageCompleter", "java.lang.String:java.lang.String:", "name:version:", "", "java.util.Set"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "names", "org.eclipse.virgo.kernel.shell.internal.completers.PackageCompleter", "java.lang.String:", "name:", "", "java.util.Set"), 68);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.completers.PackageCompleter");
    }
}

