/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.artifact;

import java.io.File;
import org.eclipse.virgo.apps.admin.core.ArtifactService;
import org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.services.work.WorkArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardArtifactService
implements ArtifactService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardArtifactService.class);
    private final ApplicationDeployer applicationDeployer;
    private final File stagingDir;

    StandardArtifactService(ApplicationDeployer applicationDeployer, WorkArea workArea) {
        this.applicationDeployer = applicationDeployer;
        this.stagingDir = workArea.getWorkDirectory().newChild("upload").createDirectory().toFile();
    }

    public String deploy(File stagedFile) {
        try {
            this.applicationDeployer.deploy(stagedFile.toURI());
            return "Artifact deployed";
        }
        catch (DeploymentException e) {
            if (!stagedFile.delete()) {
                LOGGER.warn(String.format("Failed to delete %s after a deployment exception.", stagedFile));
            }
            return String.format("Deployment Error '%s'", e.getMessage());
        }
    }

    public File getStagingDirectory() {
        return this.stagingDir;
    }
}

