/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.dump;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.virgo.apps.admin.core.DumpInspectorService;
import org.eclipse.virgo.apps.admin.core.dump.DumpPathLocator;
import org.eclipse.virgo.util.io.FileSystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StandardDumpInspectorService
implements DumpInspectorService {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final DumpPathLocator dumpPathLocator;

    public StandardDumpInspectorService(DumpPathLocator dumpPathLocator) {
        this.dumpPathLocator = dumpPathLocator;
    }

    @Override
    public List<File> findAvaliableDumps() {
        File[] dumpFolders;
        ArrayList<File> dumps = new ArrayList<File>();
        File dumpDir = this.dumpPathLocator.getDumpDirectory();
        if (dumpDir != null && (dumpFolders = FileSystemUtils.listFiles((File)dumpDir, (FileFilter)new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })).length > 0) {
            File[] fileArray = dumpFolders;
            int n = dumpFolders.length;
            int n2 = 0;
            while (n2 < n) {
                File dumpFolder = fileArray[n2];
                dumps.add(dumpFolder);
                ++n2;
            }
        }
        return dumps;
    }

    @Override
    public List<String> getDumpEntries(String dumpID) {
        if (dumpID == null) {
            return Collections.emptyList();
        }
        ArrayList<String> dumpEntries = new ArrayList<String>();
        File dumpDir = this.dumpPathLocator.getDumpFolder(dumpID);
        if (dumpDir == null) {
            dumpEntries.add(String.format("No Entries have been found for '%s'", dumpID));
        } else {
            String[] dumpEntriesArray = FileSystemUtils.list((File)dumpDir);
            if (dumpEntriesArray.length == 0) {
                dumpEntries.add(String.format("No Entries have been found for '%s'", dumpID));
            } else {
                dumpEntries.addAll((Collection)Arrays.asList(dumpEntriesArray));
            }
        }
        return dumpEntries;
    }

    @Override
    public String getDumpEntry(String dumpID, String entryName) {
        if (dumpID == null || entryName == null) {
            return "";
        }
        StringBuilder inspection = new StringBuilder();
        File dumpEntry = this.dumpPathLocator.getDumpEntryFile(dumpID, entryName);
        if (dumpEntry != null) {
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new FileReader(dumpEntry));
                while (reader.ready()) {
                    String rawLine = ((LineNumberReader)reader).readLine();
                    if (rawLine == null) continue;
                    inspection.append(this.escapeAngleBrackets(rawLine));
                    inspection.append(LINE_SEPARATOR);
                }
                reader.close();
            }
            catch (IOException iOException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException2) {}
            }
        }
        return inspection.toString();
    }

    private String escapeAngleBrackets(String unfriendlyHTML) {
        String processed = unfriendlyHTML.replace("<", "&#60;");
        processed = processed.replace(">", "&#62;");
        processed = processed.replace("\u221e", "&infin;");
        return processed;
    }
}

