/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.io.IOException;
import java.net.URLConnection;
import org.apache.naming.resources.ResourceAttributes;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleEntry;

final class BundleEntryAttributes
extends ResourceAttributes {
    private static final int CREATION_DATE_UNKNOWN = 0;
    private static final long TIME_NOT_SET = -1L;
    private static final long serialVersionUID = 7799793247259935763L;
    private final transient BundleEntry bundleEntry;
    private final String[] attrIds;
    private long lastModified = -1L;

    BundleEntryAttributes(BundleEntry bundleEntry, String[] attrIds) {
        this.bundleEntry = bundleEntry;
        this.attrIds = attrIds;
        this.setCollection(this.bundleEntry.isDirectory());
        this.getName();
        this.getLastModified();
        this.getCreation();
    }

    public long getCreation() {
        long creation = -1L;
        if ((this.attrPresent("creationdate") || this.attrPresent("creation-date")) && (creation = super.getCreation()) == -1L) {
            try {
                URLConnection urlConnection = this.bundleEntry.getURL().openConnection();
                creation = urlConnection.getDate();
                if (creation == 0L) {
                    creation = this.determineLastModified();
                }
                this.setCreation(creation);
            }
            catch (IOException iOException) {}
        }
        return creation;
    }

    private boolean attrPresent(String attrId) {
        if (this.attrIds == null) {
            return true;
        }
        String[] stringArray = this.attrIds;
        int n = this.attrIds.length;
        int n2 = 0;
        while (n2 < n) {
            String ai = stringArray[n2];
            if (ai.equals(attrId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public long getLastModified() {
        long lastModified = -1L;
        if ((this.attrPresent("getlastmodified") || this.attrPresent("last-modified")) && (lastModified = super.getLastModified()) == -1L && (lastModified = this.determineLastModified()) != -1L) {
            this.setLastModified(lastModified);
        }
        return lastModified;
    }

    private long determineLastModified() {
        if (this.lastModified == -1L) {
            try {
                URLConnection urlConnection = this.bundleEntry.getURL().openConnection();
                this.lastModified = urlConnection.getLastModified();
            }
            catch (IOException iOException) {}
        }
        return this.lastModified;
    }

    public String getName() {
        if (!this.attrPresent("displayname")) {
            return null;
        }
        String name = super.getName();
        if (name == null) {
            name = this.bundleEntry.getName();
        }
        return name;
    }
}

