/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl;

import org.apache.felix.eventadmin.impl.EventAdminImpl;
import org.apache.felix.eventadmin.impl.adapter.BundleEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.FrameworkEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.LogEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.ServiceEventAdapter;
import org.apache.felix.eventadmin.impl.dispatch.CacheThreadPool;
import org.apache.felix.eventadmin.impl.dispatch.DelayScheduler;
import org.apache.felix.eventadmin.impl.dispatch.Scheduler;
import org.apache.felix.eventadmin.impl.dispatch.TaskHandler;
import org.apache.felix.eventadmin.impl.dispatch.ThreadPool;
import org.apache.felix.eventadmin.impl.handler.BlacklistingHandlerTasks;
import org.apache.felix.eventadmin.impl.handler.CacheFilters;
import org.apache.felix.eventadmin.impl.handler.CacheTopicHandlerFilters;
import org.apache.felix.eventadmin.impl.handler.CleanBlackList;
import org.apache.felix.eventadmin.impl.handler.HandlerTasks;
import org.apache.felix.eventadmin.impl.security.CacheTopicPermissions;
import org.apache.felix.eventadmin.impl.security.SecureEventAdminFactory;
import org.apache.felix.eventadmin.impl.tasks.AsyncDeliverTasks;
import org.apache.felix.eventadmin.impl.tasks.BlockTask;
import org.apache.felix.eventadmin.impl.tasks.DeliverTasks;
import org.apache.felix.eventadmin.impl.tasks.DispatchTask;
import org.apache.felix.eventadmin.impl.tasks.SyncDeliverTasks;
import org.apache.felix.eventadmin.impl.util.LeastRecentlyUsedCacheMap;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;

public class Activator
implements BundleActivator {
    private volatile ThreadPool m_pool;
    private volatile TaskHandler m_asyncQueue;
    private volatile TaskHandler m_syncQueue;
    private volatile EventAdminImpl m_admin;
    private volatile ServiceRegistration m_registration;
    static /* synthetic */ Class class$org$osgi$service$event$EventAdmin;

    public void start(BundleContext context) {
        LogWrapper.setContext(context);
        int cacheSize = this.getIntProperty("org.apache.felix.eventadmin.CacheSize", context, 30, 10);
        int threadPoolSize = this.getIntProperty("org.apache.felix.eventadmin.ThreadPoolSize", context, 10, 2);
        int timeout = this.getIntProperty("org.apache.felix.eventadmin.Timeout", context, 5000, Integer.MIN_VALUE);
        boolean requireTopic = this.getBooleanProperty("org.apache.felix.eventadmin.RequireTopic", context, true);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.CacheSize=" + cacheSize);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.ThreadPoolSize=" + threadPoolSize);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.Timeout=" + timeout);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.RequireTopic=" + requireTopic);
        CacheTopicPermissions publishPermissions = new CacheTopicPermissions(new LeastRecentlyUsedCacheMap(cacheSize), "publish");
        CacheTopicPermissions subscribePermissions = new CacheTopicPermissions(new LeastRecentlyUsedCacheMap(cacheSize), "subscribe");
        CacheTopicHandlerFilters topicHandlerFilters = new CacheTopicHandlerFilters(new LeastRecentlyUsedCacheMap(cacheSize), requireTopic);
        CacheFilters filters = new CacheFilters(new LeastRecentlyUsedCacheMap(cacheSize), context);
        BlacklistingHandlerTasks handlerTasks = new BlacklistingHandlerTasks(context, new CleanBlackList(), topicHandlerFilters, filters, subscribePermissions);
        Scheduler scheduler = this.createScheduler(timeout);
        this.m_pool = new CacheThreadPool(threadPoolSize);
        this.m_asyncQueue = new TaskHandler();
        this.m_syncQueue = new TaskHandler();
        this.m_admin = this.createEventAdmin(context, handlerTasks, this.createAsyncExecuters(this.m_asyncQueue, this.m_syncQueue, scheduler, this.m_pool), this.createSyncExecuters(this.m_syncQueue, scheduler, this.m_pool));
        this.m_registration = context.registerService((class$org$osgi$service$event$EventAdmin == null ? (class$org$osgi$service$event$EventAdmin = Activator.class$("org.osgi.service.event.EventAdmin")) : class$org$osgi$service$event$EventAdmin).getName(), (Object)new SecureEventAdminFactory(this.m_admin, publishPermissions), null);
        this.adaptEvents(context, this.m_admin);
    }

    public void stop(BundleContext context) {
        this.m_registration.unregister();
        this.m_admin.stop();
        BlockTask asyncShutdownBlock = new BlockTask();
        BlockTask syncShutdownBlock = new BlockTask();
        this.m_asyncQueue.close(asyncShutdownBlock);
        this.m_syncQueue.close(syncShutdownBlock);
        this.m_admin = null;
        this.m_asyncQueue = null;
        this.m_syncQueue = null;
        this.m_registration = null;
        DispatchTask task = this.m_pool.getTask(Thread.currentThread(), null);
        if (null != task) {
            task.handover();
        }
        asyncShutdownBlock.block();
        syncShutdownBlock.block();
        this.m_pool.close();
        this.m_pool = null;
    }

    protected EventAdminImpl createEventAdmin(BundleContext context, HandlerTasks handlerTasks, DeliverTasks asyncExecuters, DeliverTasks syncExecuters) {
        return new EventAdminImpl(handlerTasks, asyncExecuters, syncExecuters);
    }

    private DeliverTasks createAsyncExecuters(TaskHandler handler, TaskHandler handoverHandler, Scheduler scheduler, ThreadPool pool) {
        AsyncDeliverTasks result = new AsyncDeliverTasks(handler, handoverHandler, pool);
        result.execute(new DispatchTask(handler, scheduler, result));
        return result;
    }

    private DeliverTasks createSyncExecuters(TaskHandler handler, Scheduler scheduler, ThreadPool pool) {
        SyncDeliverTasks result = new SyncDeliverTasks(handler, pool);
        result.execute(new DispatchTask(handler, scheduler, result));
        return result;
    }

    private Scheduler createScheduler(int timeout) {
        if (100 > timeout) {
            return Scheduler.NULL_SCHEDULER;
        }
        return new DelayScheduler(timeout);
    }

    private void adaptEvents(BundleContext context, EventAdmin admin) {
        new FrameworkEventAdapter(context, admin);
        new BundleEventAdapter(context, admin);
        new ServiceEventAdapter(context, admin);
        new LogEventAdapter(context, admin);
    }

    private int getIntProperty(String key, BundleContext context, int defaultValue, int min) {
        String value = context.getProperty(key);
        if (null != value) {
            try {
                int result = Integer.parseInt(value);
                if (result >= min) {
                    return result;
                }
                LogWrapper.getLogger().log(2, "Value for property: " + key + " is to low - Using default");
            }
            catch (NumberFormatException e) {
                LogWrapper.getLogger().log(2, "Unable to parse property: " + key + " - Using default", e);
            }
        }
        return defaultValue;
    }

    private boolean getBooleanProperty(String key, BundleContext context, boolean defaultValue) {
        String value = context.getProperty(key);
        if (null != value) {
            if (0 < (value = value.trim().toLowerCase()).length() && ("0".equals(value) || "false".equals(value) || "no".equals(value))) {
                return false;
            }
            if (0 < value.length() && ("1".equals(value) || "true".equals(value) || "yes".equals(value))) {
                return true;
            }
        }
        return defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

