/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.hot;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.FatalDeploymentException;
import org.eclipse.virgo.kernel.deployer.hot.HotDeployerLogEvents;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.FileSystemEvent;
import org.eclipse.virgo.util.io.FileSystemListener;
import org.eclipse.virgo.util.io.PathReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HotDeploymentFileSystemListener
implements FileSystemListener {
    private final Logger logger;
    private final EventLogger eventLogger;
    private final ApplicationDeployer deployer;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$virgo$util$io$FileSystemEvent;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public HotDeploymentFileSystemListener(@NonNull ApplicationDeployer deployer, EventLogger eventLogger) {
        ApplicationDeployer applicationDeployer = deployer;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)applicationDeployer);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.deployer = deployer;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onChange(String path, FileSystemEvent event) {
        try {
            try {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                String fileName = new PathReference(path).getName();
                this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_PROCESSING_FILE, new Object[]{event, fileName});
                try {
                    if (event == FileSystemEvent.CREATED) {
                        this.logger.info("ApplicationDeploying path '{}'.", (Object)path);
                        this.deploy(path);
                    } else if (event == FileSystemEvent.MODIFIED) {
                        this.logger.info("Redeploying path '{}'.", (Object)path);
                        this.deploy(path);
                    } else if (event == FileSystemEvent.DELETED) {
                        this.logger.info("ApplicationUndeploying path '{}'.", (Object)path);
                        this.undeploy(path);
                    } else if (event == FileSystemEvent.INITIAL) {
                        this.logger.info("ApplicationConditionallyDeploying path '{}'.", (Object)path);
                        this.deployIfNotDeployed(path, fileName);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    this.determineFailureAndLogMessage(event, fileName, ex);
                }
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void determineFailureAndLogMessage(FileSystemEvent event, String fileName, Exception ex) {
        try {
            try {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                switch (HotDeploymentFileSystemListener.$SWITCH_TABLE$org$eclipse$virgo$util$io$FileSystemEvent()[event.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_FAILED, (Throwable)ex, new Object[]{fileName});
                        break;
                    }
                    case 4: {
                        this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_REDEPLOY_FAILED, (Throwable)ex, new Object[]{fileName});
                        break;
                    }
                    case 3: {
                        this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_UNDEPLOY_FAILED, (Throwable)ex, new Object[]{fileName});
                    }
                }
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void undeploy(String sourceArtefact) throws DeploymentException {
        try {
            try {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                DeploymentIdentity deploymentIdentity = this.getDeploymentIdentity(sourceArtefact);
                if (deploymentIdentity != null) {
                    this.deployer.undeploy(deploymentIdentity);
                }
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity getDeploymentIdentity(String sourceArtefact) {
        try {
            return this.deployer.getDeploymentIdentity(this.getDefinitiveUri(sourceArtefact));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isDeployed(String sourceArtefact) {
        try {
            try {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                boolean bl = this.deployer.isDeployed(this.getDefinitiveUri(sourceArtefact));
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return bl;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private URI getDefinitiveUri(String sourceArtefact) {
        try {
            URI baseUri = new File(sourceArtefact).toURI();
            if (sourceArtefact.endsWith(File.separator) && !baseUri.toString().endsWith("/")) {
                try {
                    baseUri = new URI(String.valueOf(baseUri.toString()) + "/");
                }
                catch (URISyntaxException e) {
                    throw new FatalDeploymentException("Unexpected URI syntax problem.", e);
                }
            }
            return baseUri;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void deploy(String sourceArtefact) throws DeploymentException {
        try {
            try {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                this.deployer.deploy(this.getDefinitiveUri(sourceArtefact), new ApplicationDeployer.DeploymentOptions(true, true, false));
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void deployIfNotDeployed(String sourceArtefact, String fileName) throws DeploymentException {
        try {
            try {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                if (!this.isDeployed(sourceArtefact)) {
                    this.deploy(sourceArtefact);
                } else {
                    this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_SKIPPED, new Object[]{fileName});
                }
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String toString() {
        try {
            try {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
                String string = "Hot Deploy Listener";
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
                return string;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$virgo$util$io$FileSystemEvent() {
        try {
            try {
                int[] nArray;
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                if ($SWITCH_TABLE$org$eclipse$virgo$util$io$FileSystemEvent != null) {
                    nArray = $SWITCH_TABLE$org$eclipse$virgo$util$io$FileSystemEvent;
                } else {
                    int[] nArray2 = new int[FileSystemEvent.values().length];
                    try {
                        nArray2[FileSystemEvent.CREATED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray2[FileSystemEvent.DELETED.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray2[FileSystemEvent.INITIAL.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray2[FileSystemEvent.MODIFIED.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    $SWITCH_TABLE$org$eclipse$virgo$util$io$FileSystemEvent = nArray2;
                    nArray = nArray2;
                }
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return nArray;
            }
            catch (Throwable throwable) {
                HotDeploymentFileSystemListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("HotDeploymentFileSystemListener.java", Class.forName("org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onChange", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "java.lang.String:org.eclipse.virgo.util.io.FileSystemEvent:", "path:event:", "", "void"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineFailureAndLogMessage", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "org.eclipse.virgo.util.io.FileSystemEvent:java.lang.String:java.lang.Exception:", "event:fileName:ex:", "", "void"), 99);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "undeploy", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "java.lang.String:", "sourceArtefact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 120);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isDeployed", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "java.lang.String:", "sourceArtefact:", "", "boolean"), 145);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deploy", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "java.lang.String:", "sourceArtefact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 174);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deployIfNotDeployed", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "java.lang.String:java.lang.String:", "sourceArtefact:fileName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 185);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "", "", "", "java.lang.String"), 197);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "$SWITCH_TABLE$org$eclipse$virgo$util$io$FileSystemEvent", "org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener", "", "", "", "[I"), 48);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.hot.HotDeploymentFileSystemListener");
    }
}

