/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.Shutdown;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkLogEvents;
import org.eclipse.virgo.kernel.osgi.region.PackageImportWildcardExpander;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.osgi.launcher.parser.ArgumentParser;
import org.eclipse.virgo.osgi.launcher.parser.BundleEntry;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.launch.Framework;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.framework.CompositeBundle;
import org.osgi.service.framework.CompositeBundleFactory;
import org.osgi.service.framework.SurrogateBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegionManager {
    private static final String USER_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel.userregion";
    private static final String PLUGGABLE_CLASS_LOADING_HOOK_CLASS_NAME = "org.eclipse.virgo.osgi.extensions.equinox.hooks.PluggableClassLoadingHook";
    private static final String USER_REGION_BASE_BUNDLES_PROPERTY = "baseBundles";
    private static final String USER_REGION_PACKAGE_IMPORTS_PROPERTY = "packageImports";
    private static final String USER_REGION_SERVICE_IMPORTS_PROPERTY = "serviceImports";
    private static final String USER_REGION_SERVICE_EXPORTS_PROPERTY = "serviceExports";
    private static final String USER_REGION_PROPERTIES_PROPERTY = "inheritedFrameworkProperties";
    private static final String REGION_USER = "org.eclipse.virgo.region.user";
    private static final String EVENT_REGION_STARTING = "org/eclipse/virgo/kernel/region/STARTING";
    private static final Object EVENT_PROPERTY_REGION_BUNDLECONTEXT;
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private final BundleContext bundleContext;
    private final CompositeBundleFactory compositeBundleFactory;
    private final ArgumentParser parser = new ArgumentParser();
    private final EventAdmin eventAdmin;
    private final ServiceFactory eventLoggerServiceFactory;
    private volatile Framework childFramework;
    private Dictionary<String, String> userRegionProperties;
    private String regionBundles;
    private String regionImports;
    private String regionServiceImports;
    private String regionServiceExports;
    private String regionInheritedProperties;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

    static {
        Factory factory = new Factory("RegionManager.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.RegionManager"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "org.osgi.framework.BundleException:", "void"), 137);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAndPublishUserRegion", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "org.osgi.framework.BundleException:", "void"), 142);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "configureServiceExportFilter", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "java.util.Map:", "compositeManifest:", "", "void"), 280);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "splitServices", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "java.lang.String:", "serviceString:", "", "[Ljava.lang.String;"), 287);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createObjectClassesServiceFilter", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "[Ljava.lang.String;:", "serviceClassNames:", "", "java.lang.String"), 295);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createObjectClassFilter", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "java.lang.String:", "className:", "", "java.lang.String"), 305);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initialiseUserRegionBundles", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.BundleContext:", "surrogateBundleContext:", "org.osgi.framework.BundleException:", "void"), 309);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerRegionService", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 335);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "", "void"), 341);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerEventLoggerServiceFactory", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.BundleContext:", "surrogateBundleContext:", "", "void"), 167);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "publishUserRegionsBundleContext", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.BundleContext:", "surrogateBundleContext:", "", "void"), 174);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "invokeGetInstance", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "java.lang.Class:", "pluggableClassLoadingHookClass:", "java.lang.SecurityException:java.lang.NoSuchMethodException:java.lang.IllegalArgumentException:java.lang.IllegalAccessException:java.lang.reflect.InvocationTargetException:", "java.lang.Object"), 199);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "invokeSetParent", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "java.lang.Class:java.lang.Object:java.lang.ClassLoader:", "pluggableClassLoadingHookClass:pluggableClassLoadingHookInstance:parentClassLoader:", "java.lang.NoSuchMethodException:java.lang.IllegalAccessException:java.lang.reflect.InvocationTargetException:", "void"), 207);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createChildFrameworkConfig", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "", "java.util.Map"), 214);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "propagatePropertyToUserRegion", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "java.util.HashMap:java.lang.String:", "frameworkConfig:propertyName:", "", "void"), 247);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createCompositeBundleManifest", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "", "java.util.Map"), 254);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "configureServiceImportFilter", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "java.util.Map:", "compositeManifest:", "", "void"), 273);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.RegionManager");
        EVENT_PROPERTY_REGION_BUNDLECONTEXT = "region.bundleContext";
    }

    public RegionManager(BundleContext bundleContext, CompositeBundleFactory compositeBundleFactory, EventAdmin eventAdmin, ServiceFactory eventLoggerServiceFactory, ConfigurationAdmin configAdmin, EventLogger eventLogger, Shutdown shutdown) {
        this.bundleContext = bundleContext;
        this.compositeBundleFactory = compositeBundleFactory;
        this.eventAdmin = eventAdmin;
        this.eventLoggerServiceFactory = eventLoggerServiceFactory;
        this.getRegionConfiguration(configAdmin, eventLogger, shutdown);
    }

    private void getRegionConfiguration(ConfigurationAdmin configAdmin, EventLogger eventLogger, Shutdown shutdown) {
        try {
            Configuration config = configAdmin.getConfiguration(USER_REGION_CONFIGURATION_PID);
            Dictionary properties = config.getProperties();
            if (properties != null) {
                this.userRegionProperties = properties;
                this.regionBundles = (String)properties.get(USER_REGION_BASE_BUNDLES_PROPERTY);
                this.regionImports = (String)properties.get(USER_REGION_PACKAGE_IMPORTS_PROPERTY);
                this.regionServiceImports = (String)properties.get(USER_REGION_SERVICE_IMPORTS_PROPERTY);
                this.regionServiceExports = (String)properties.get(USER_REGION_SERVICE_EXPORTS_PROPERTY);
                this.regionInheritedProperties = (String)properties.get(USER_REGION_PROPERTIES_PROPERTY);
            } else {
                eventLogger.log((LogEvent)OsgiFrameworkLogEvents.USER_REGION_CONFIGURATION_UNAVAILABLE, new Object[0]);
                shutdown.immediateShutdown();
            }
        }
        catch (Exception e) {
            eventLogger.log((LogEvent)OsgiFrameworkLogEvents.USER_REGION_CONFIGURATION_UNAVAILABLE, (Throwable)e, new Object[0]);
            shutdown.immediateShutdown();
        }
    }

    public void start() throws BundleException {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            this.createAndPublishUserRegion();
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void createAndPublishUserRegion() throws BundleException {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            CompositeBundle compositeBundle = this.compositeBundleFactory.installCompositeBundle(this.createChildFrameworkConfig(), REGION_USER, this.createCompositeBundleManifest());
            this.childFramework = compositeBundle.getCompositeFramework();
            compositeBundle.start();
            this.childFramework.start();
            SurrogateBundle surrogateBundle = compositeBundle.getSurrogateBundle();
            BundleContext surrogateBundleContext = surrogateBundle.getBundleContext();
            Properties properties = new Properties();
            properties.put(EVENT_PROPERTY_REGION_BUNDLECONTEXT, surrogateBundleContext);
            this.eventAdmin.sendEvent(new Event(EVENT_REGION_STARTING, (Dictionary)properties));
            this.setUserRegionBundleParentClassLoader(surrogateBundleContext);
            this.registerEventLoggerServiceFactory(surrogateBundleContext);
            this.initialiseUserRegionBundles(surrogateBundleContext);
            this.registerRegionService(new ImmutableRegion(REGION_USER, surrogateBundleContext));
            this.publishUserRegionsBundleContext(surrogateBundleContext);
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void registerEventLoggerServiceFactory(BundleContext surrogateBundleContext) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            surrogateBundleContext.registerService(EventLogger.class.getName(), (Object)this.eventLoggerServiceFactory, null);
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void publishUserRegionsBundleContext(BundleContext surrogateBundleContext) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            Properties properties = new Properties();
            properties.put("org.eclipse.virgo.kernel.regionContext", "true");
            this.bundleContext.registerService(BundleContext.class.getName(), (Object)surrogateBundleContext, (Dictionary)properties);
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void setUserRegionBundleParentClassLoader(BundleContext surrogateBundleContext) throws BundleException {
        ClassLoader surrogateClassLoader = surrogateBundleContext.getClass().getClassLoader();
        try {
            this.setUserRegionHookBundleParentClassLoader(surrogateClassLoader);
        }
        catch (Exception e) {
            throw new BundleException("Error setting user region hook bundle parent class loader", (Throwable)e);
        }
    }

    private void setUserRegionHookBundleParentClassLoader(ClassLoader parentClassLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> pluggableClassLoadingHookClass = parentClassLoader.loadClass(PLUGGABLE_CLASS_LOADING_HOOK_CLASS_NAME);
        Object pluggableClassLoadingHookInstance = this.invokeGetInstance(pluggableClassLoadingHookClass);
        this.invokeSetParent(pluggableClassLoadingHookClass, pluggableClassLoadingHookInstance, parentClassLoader);
    }

    private Object invokeGetInstance(Class<?> pluggableClassLoadingHookClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            Class[] parmTypes = new Class[]{};
            Method getInstanceMethod = pluggableClassLoadingHookClass.getDeclaredMethod("getInstance", parmTypes);
            Object[] args = new Object[]{};
            Object object = getInstanceMethod.invoke(null, args);
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return object;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private void invokeSetParent(Class<?> pluggableClassLoadingHookClass, Object pluggableClassLoadingHookInstance, ClassLoader parentClassLoader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            Class[] parmTypes = new Class[]{ClassLoader.class};
            Method setParentMethod = pluggableClassLoadingHookClass.getDeclaredMethod("setBundleClassLoaderParent", parmTypes);
            Object[] args = new Object[]{parentClassLoader};
            setParentMethod.invoke(pluggableClassLoadingHookInstance, args);
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private Map<String, String> createChildFrameworkConfig() {
        try {
            String userRegionImportsProperty;
            String property;
            int n;
            int n2;
            String[] stringArray;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            HashMap<String, String> frameworkConfig = new HashMap<String, String>();
            this.setUserConfiguredUserRegionProperties(frameworkConfig);
            if (this.regionInheritedProperties != null) {
                String[] inheritedProperties;
                stringArray = inheritedProperties = this.regionInheritedProperties.split(",");
                n2 = inheritedProperties.length;
                n = 0;
                while (n < n2) {
                    property = stringArray[n];
                    this.propagatePropertyToUserRegion(frameworkConfig, property);
                    ++n;
                }
            }
            if ((userRegionImportsProperty = this.bundleContext.getProperty(USER_REGION_PROPERTIES_PROPERTY)) != null) {
                stringArray = userRegionImportsProperty.split(",");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    property = stringArray[n];
                    this.propagatePropertyToUserRegion(frameworkConfig, property);
                    ++n;
                }
            }
            HashMap<String, String> hashMap = frameworkConfig;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return hashMap;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private void setUserConfiguredUserRegionProperties(HashMap<String, String> frameworkConfig) {
        if (this.userRegionProperties != null) {
            Enumeration<String> keys = this.userRegionProperties.keys();
            while (keys.hasMoreElements()) {
                String propertyName = keys.nextElement();
                String propertyValue = this.userRegionProperties.get(propertyName);
                frameworkConfig.put(propertyName, propertyValue);
            }
        }
    }

    private void propagatePropertyToUserRegion(HashMap<String, String> frameworkConfig, String propertyName) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            String propertyValue = this.bundleContext.getProperty(propertyName);
            if (propertyValue != null) {
                frameworkConfig.put(propertyName, propertyValue);
            }
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private Map<String, String> createCompositeBundleManifest() {
        try {
            String userRegionImportsProperty;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            HashMap<String, String> compositeManifest = new HashMap<String, String>();
            compositeManifest.put("Bundle-SymbolicName", REGION_USER);
            String string = userRegionImportsProperty = this.regionImports != null ? this.regionImports : this.bundleContext.getProperty(USER_REGION_PACKAGE_IMPORTS_PROPERTY);
            if (userRegionImportsProperty != null) {
                String expandedUserRegionImportsProperty = PackageImportWildcardExpander.expandPackageImportsWildcards(userRegionImportsProperty, this.bundleContext);
                compositeManifest.put("Import-Package", expandedUserRegionImportsProperty);
            }
            this.configureServiceImportFilter(compositeManifest);
            this.configureServiceExportFilter(compositeManifest);
            HashMap<String, String> hashMap = compositeManifest;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return hashMap;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private void configureServiceImportFilter(Map<String, String> compositeManifest) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
            String[] serviceImports = this.splitServices(this.regionServiceImports);
            if (serviceImports != null) {
                compositeManifest.put("CompositeServiceFilter-Import", this.createObjectClassesServiceFilter(serviceImports));
            }
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    private void configureServiceExportFilter(Map<String, String> compositeManifest) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
            String[] serviceExports = this.splitServices(this.regionServiceExports);
            if (serviceExports != null) {
                compositeManifest.put("CompositeServiceFilter-Export", this.createObjectClassesServiceFilter(serviceExports));
            }
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    private String[] splitServices(String serviceString) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
            String[] services = null;
            if (serviceString != null) {
                services = serviceString.split(",");
            }
            String[] stringArray = services;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
            return stringArray;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    private String createObjectClassesServiceFilter(String[] serviceClassNames) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
            StringBuffer importFilter = new StringBuffer();
            importFilter.append("(|");
            String[] stringArray = serviceClassNames;
            int n = serviceClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                importFilter.append(this.createObjectClassFilter(className));
                ++n2;
            }
            importFilter.append(")");
            String string = importFilter.toString();
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
            return string;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    private String createObjectClassFilter(String className) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_13);
            String string = "(objectClass=" + className + ")";
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_13);
            return string;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_13);
            throw throwable;
        }
    }

    private void initialiseUserRegionBundles(BundleContext surrogateBundleContext) throws BundleException {
        try {
            String userRegionBundlesProperty;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_14);
            String string = userRegionBundlesProperty = this.regionBundles != null ? this.regionBundles : this.bundleContext.getProperty(USER_REGION_BASE_BUNDLES_PROPERTY);
            if (userRegionBundlesProperty != null) {
                ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
                BundleEntry[] bundleEntryArray = this.parser.parseBundleEntries(userRegionBundlesProperty);
                int n = bundleEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleEntry entry = bundleEntryArray[n2];
                    Bundle bundle = surrogateBundleContext.installBundle(entry.getURI().toString());
                    if (entry.isAutoStart()) {
                        bundlesToStart.add(bundle);
                    }
                    ++n2;
                }
                for (Bundle bundle : bundlesToStart) {
                    try {
                        bundle.start();
                    }
                    catch (BundleException e) {
                        throw new BundleException("Failed to start bundle " + bundle.getSymbolicName() + " " + bundle.getVersion(), (Throwable)e);
                    }
                }
            }
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_14);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_14);
            throw throwable;
        }
    }

    private void registerRegionService(Region region) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_15);
            Properties props = new Properties();
            props.setProperty("org.eclipse.virgo.kernel.region.name", region.getName());
            this.tracker.track(this.bundleContext.registerService(Region.class.getName(), (Object)region, (Dictionary)props));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_15);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_15);
            throw throwable;
        }
    }

    public void stop() {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_16);
            this.tracker.unregisterAll();
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_16);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_16);
            throw throwable;
        }
    }

    private static class ImmutableRegion
    implements Region {
        private final String name;
        private final BundleContext bundleContext;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public ImmutableRegion(String name, BundleContext bundleContext) {
            this.name = name;
            this.bundleContext = bundleContext;
        }

        public String getName() {
            return this.name;
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.RegionManager$ImmutableRegion");
        }
    }
}

