/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.fs.internal;

import java.io.File;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.artifact.fs.internal.FileArtifactFSEntry;
import org.eclipse.virgo.util.common.StringUtils;

public class FileArtifactFS
implements ArtifactFS {
    private final File file;

    public FileArtifactFS(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(String.format("This ArtifactFS cannot be created for '%s' as it is a directory", file.getAbsolutePath()));
        }
        this.file = file;
    }

    public ArtifactFSEntry getEntry(String name) {
        if (StringUtils.hasText((String)name)) {
            throw new IllegalArgumentException("This ArtifactFS represents a single static file.  Requesting any entry other than null or \"\" is unsupported");
        }
        return new FileArtifactFSEntry(this.file.getParentFile(), this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

