/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gemini.web.core.spi.ContextPathExistsException;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.web.core.internal.WebLogEvents;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

final class WebApplicationEventLogger
implements EventHandler {
    private static final String EMPTY_CONTEXT_PATH = "";
    private static final String ROOT_CONTEXT_PATH = "/";
    private final EventLogger eventLogger;
    private static final Map<String, WebLogEvents> MAPPINGS;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WebApplicationEventLogger");
        HashMap<String, WebLogEvents> mappings = new HashMap<String, WebLogEvents>();
        mappings.put("org/osgi/service/web/DEPLOYING", WebLogEvents.STARTING_WEB_BUNDLE);
        mappings.put("org/osgi/service/web/DEPLOYED", WebLogEvents.STARTED_WEB_BUNDLE);
        mappings.put("org/osgi/service/web/UNDEPLOYING", WebLogEvents.STOPPING_WEB_BUNDLE);
        mappings.put("org/osgi/service/web/UNDEPLOYED", WebLogEvents.STOPPED_WEB_BUNDLE);
        MAPPINGS = mappings;
    }

    public WebApplicationEventLogger(EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void handleEvent(Event event) {
        try {
            String topic = event.getTopic();
            if ("org/osgi/service/web/FAILED".equals(topic)) {
                this.logFailure(event);
            } else {
                WebLogEvents logEvent = MAPPINGS.get(topic);
                if (logEvent != null) {
                    this.eventLogger.log((LogEvent)logEvent, new Object[]{this.bundleName(event), this.bundleVersion(event), this.contextPathFor(event)});
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void logFailure(Event event) {
        try {
            Exception ex = (Exception)event.getProperty("exception");
            if (ex instanceof ContextPathExistsException) {
                this.eventLogger.log((LogEvent)WebLogEvents.WEB_BUNDLE_FAILED_CONTEXT_PATH_USED, new Object[]{this.bundleName(event), this.bundleVersion(event), this.contextPathFor(event)});
            } else {
                this.eventLogger.log((LogEvent)WebLogEvents.WEB_BUNDLE_FAILED, new Object[]{this.bundleName(event), this.bundleVersion(event)});
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String contextPathFor(Event event) {
        try {
            String contextPath = (String)event.getProperty("context.path");
            if (EMPTY_CONTEXT_PATH.equals(contextPath)) {
                return ROOT_CONTEXT_PATH;
            }
            return contextPath;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String bundleName(Event event) {
        try {
            return (String)event.getProperty("bundle.symbolicName");
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Version bundleVersion(Event event) {
        try {
            return (Version)event.getProperty("bundle.version");
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

