/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringLiteral
extends AbstractExpression {
    private Boolean hasCloseQuote;

    public StringLiteral(AbstractExpression parent, String literal) {
        super(parent, literal);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("string_literal");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public String getUnquotedText() {
        return ExpressionTools.unquote(this.getText());
    }

    public boolean hasCloseQuote() {
        if (this.hasCloseQuote == null) {
            String text = this.getText();
            int length = text.length();
            this.hasCloseQuote = length > 1 && ExpressionTools.isQuote(text.charAt(length - 1));
        }
        return this.hasCloseQuote;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(this.getText());
    }

    @Override
    public String toActualText() {
        return this.getText();
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(this.getText());
    }
}

