/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.commands.AbstractInstallArtifactBasedCommands;
import org.eclipse.virgo.shell.internal.formatting.BundleInstallArtifactCommandFormatter;
import org.eclipse.virgo.shell.internal.util.QuasiBundleUtil;
import org.eclipse.virgo.shell.internal.util.QuasiServiceUtil;
import org.osgi.framework.Version;

@Command(value="bundle")
final class BundleCommands
extends AbstractInstallArtifactBasedCommands<ManageableArtifact> {
    private static final String NO_BUNDLE_FOR_BUNDLE_ID = "No bundle with id '%s' was found";
    private static final String TYPE = "bundle";
    private final BundleInstallArtifactCommandFormatter formatter;
    private final QuasiBundleUtil quasiBundleUtil;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public BundleCommands(RuntimeArtifactModelObjectNameCreator objectNameCreator, QuasiBundleUtil quasiBundleUtil, QuasiServiceUtil quasiServiceUtil, ModuleContextAccessor moduleContextAccessor, RegionDigraph regionDigraph) {
        super(TYPE, objectNameCreator, new BundleInstallArtifactCommandFormatter(regionDigraph, quasiBundleUtil, quasiServiceUtil, moduleContextAccessor), ManageableArtifact.class, regionDigraph);
        this.quasiBundleUtil = quasiBundleUtil;
        this.formatter = new BundleInstallArtifactCommandFormatter(regionDigraph, quasiBundleUtil, quasiServiceUtil, moduleContextAccessor);
    }

    @Command(value="examine")
    public List<String> examine(long id) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
            List<String> list = bundle != null ? this.examine(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName()) : Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Command(value="start")
    public List<String> start(long id) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
            List<String> list = bundle != null ? this.start(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName()) : Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    @Command(value="stop")
    public List<String> stop(long id) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
            List<String> list = bundle != null ? this.stop(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName()) : Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    @Command(value="refresh")
    public List<String> refresh(long id) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
            List<String> list = bundle != null ? this.refresh(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName()) : Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    @Command(value="uninstall")
    public List<String> uninstall(long id) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
            List<String> list = bundle != null ? this.uninstall(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName()) : Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    @Command(value="diag")
    public List<String> diag(long id) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
            List<String> list = bundle != null ? this.diag(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName()) : Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    @Command(value="diag")
    public List<String> diag(String name, String version, String region) {
        try {
            List<String> list;
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
            QuasiBundle bundle = this.getBundle(name, version, region);
            if (bundle != null) {
                List<QuasiResolutionFailure> resolverReport = this.quasiBundleUtil.getResolverReport(bundle.getBundleId());
                list = this.formatter.formatDiag(bundle, resolverReport);
            } else {
                list = this.getDoesNotExistMessage(TYPE, name, version, region);
            }
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    @Command(value="headers")
    public List<String> headers(long id) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
            QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
            List<String> list = bundle != null ? this.headers(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName()) : Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    @Command(value="headers")
    public List<String> headers(String name, String version, String region) {
        try {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_8);
            List<String> list = this.formatter.formatHeaders(this.getBundle(name, version, region));
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_8);
            return list;
        }
        catch (Throwable throwable) {
            BundleCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private QuasiBundle getBundle(String name, String version, String region) {
        Version v = new Version(version);
        List<QuasiBundle> bundles = this.quasiBundleUtil.getAllBundles();
        for (QuasiBundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(name) || !bundle.getVersion().equals((Object)v) || !bundle.getRegion().equals(region)) continue;
            return bundle;
        }
        return null;
    }

    static {
        Factory factory = new Factory("BundleCommands.java", Class.forName("org.eclipse.virgo.shell.internal.commands.BundleCommands"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "examine", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "long:", "id:", "", "java.util.List"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "long:", "id:", "", "java.util.List"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "long:", "id:", "", "java.util.List"), 80);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "long:", "id:", "", "java.util.List"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uninstall", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "long:", "id:", "", "java.util.List"), 100);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "diag", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "long:", "id:", "", "java.util.List"), 110);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "diag", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "java.lang.String:java.lang.String:java.lang.String:", "name:version:region:", "", "java.util.List"), 120);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "headers", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "long:", "id:", "", "java.util.List"), 131);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "headers", "org.eclipse.virgo.shell.internal.commands.BundleCommands", "java.lang.String:java.lang.String:java.lang.String:", "name:version:region:", "", "java.util.List"), 141);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.internal.commands.BundleCommands");
    }
}

