/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.util.Vector;
import org.objectweb.jotm.Batch;
import org.objectweb.jotm.Clock;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TraceTm;

public class TimerManager {
    private static Batch batchThread;
    private static Clock clockThread;
    private Vector timerList = new Vector();
    private Vector expiredList = new Vector();
    private static TimerManager unique;
    private static boolean shuttingdown;

    private TimerManager() {
        batchThread = new Batch(this);
        batchThread.setDaemon(true);
        clockThread = new Clock(this);
        clockThread.setDaemon(true);
    }

    public static synchronized TimerManager getInstance() {
        if (unique == null) {
            unique = new TimerManager();
            batchThread.start();
            clockThread.start();
        }
        return unique;
    }

    public static void stop(boolean force) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Stop TimerManager");
        }
        TimerManager tmgr = TimerManager.getInstance();
        shuttingdown = true;
        while (clockThread.isAlive() || batchThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TimerManager has stopped");
        }
    }

    public static void stop() {
        TimerManager.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clock() {
        Vector vector;
        block6: while (true) {
            try {
                while (true) {
                    Thread.sleep(shuttingdown ? 1L : 1000L);
                    vector = this.timerList;
                    synchronized (vector) {
                        int found = 0;
                        boolean empty = true;
                        for (int i = 0; i < this.timerList.size(); ++i) {
                            TimerEvent t = (TimerEvent)this.timerList.elementAt(i);
                            if (!t.isStopped()) {
                                empty = false;
                            }
                            if (t.update() <= 0L) {
                                this.timerList.removeElementAt(i--);
                                if (t.valid()) {
                                    this.expiredList.addElement(t);
                                    ++found;
                                    if (t.ispermanent() && !shuttingdown) {
                                        t.restart();
                                        this.timerList.addElement(t);
                                    }
                                }
                            }
                            t = null;
                        }
                        if (found > 0) {
                            this.timerList.notify();
                        } else if (empty && shuttingdown) {
                            break block6;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                TraceTm.jta.error((Object)"Timer interrupted");
                continue;
            }
            break;
        }
        vector = this.timerList;
        synchronized (vector) {
            this.timerList.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch() {
        while (!(shuttingdown && this.timerList.isEmpty() && this.expiredList.isEmpty())) {
            TimerEvent t;
            Vector vector = this.timerList;
            synchronized (vector) {
                while (this.expiredList.isEmpty()) {
                    if (shuttingdown) {
                        return;
                    }
                    try {
                        this.timerList.wait();
                    }
                    catch (Exception e) {
                        TraceTm.jta.error((Object)"Exception in Batch: ", (Throwable)e);
                    }
                }
                t = (TimerEvent)this.expiredList.elementAt(0);
                this.expiredList.removeElementAt(0);
            }
            t.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerEvent addTimer(TimerEventListener tel, long timeout, Object arg, boolean permanent) {
        TimerEvent te = new TimerEvent(tel, timeout, arg, permanent);
        Vector vector = this.timerList;
        synchronized (vector) {
            this.timerList.addElement(te);
        }
        return te;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimer(TimerEvent te) {
        Vector vector = this.timerList;
        synchronized (vector) {
            this.timerList.removeElement(te);
        }
    }

    static {
        unique = null;
        shuttingdown = false;
    }
}

