/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateless;

import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBContext;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.InstanceContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateless.EjbWsContext;
import org.apache.openejb.core.stateless.Instance;
import org.apache.openejb.core.stateless.StatelessContext;
import org.apache.openejb.core.timer.TimerServiceWrapper;
import org.apache.openejb.loader.Options;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PassthroughFactory;
import org.apache.openejb.util.Pool;
import org.apache.openejb.util.SafeToolkit;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class StatelessInstanceManager {
    private static final Logger logger;
    private static final Method removeSessionBeanMethod;
    protected Duration accessTimeout;
    protected Duration closeTimeout;
    protected int beanCount = 0;
    protected final SafeToolkit toolkit = SafeToolkit.getToolkit("StatefulInstanceManager");
    private SecurityService securityService;
    private final Pool.Builder poolBuilder;
    private final Executor executor;

    public StatelessInstanceManager(SecurityService securityService, Duration accessTimeout, Duration closeTimeout, Pool.Builder poolBuilder, int callbackThreads) {
        this.securityService = securityService;
        this.accessTimeout = accessTimeout;
        this.closeTimeout = closeTimeout;
        this.poolBuilder = poolBuilder;
        if (accessTimeout.getUnit() == null) {
            accessTimeout.setUnit(TimeUnit.MILLISECONDS);
        }
        this.executor = new ThreadPoolExecutor(callbackThreads, callbackThreads * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "StatelessPool");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public Object getInstance(ThreadContext callContext) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        Data data = (Data)beanContext.getContainerData();
        Instance instance = null;
        try {
            Pool.Entry entry = data.poolPop();
            if (entry != null) {
                instance = (Instance)entry.get();
                instance.setPoolEntry(entry);
            }
        }
        catch (TimeoutException e) {
            ConcurrentAccessTimeoutException timeoutException = new ConcurrentAccessTimeoutException("No instances available in Stateless Session Bean pool.  Waited " + data.accessTimeout.toString());
            timeoutException.fillInStackTrace();
            throw new ApplicationException((Exception)timeoutException);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OpenEJBException("Unexpected Interruption of current thread: ", e);
        }
        if (instance != null) {
            return instance;
        }
        return this.ceateInstance(callContext, beanContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instance ceateInstance(ThreadContext callContext, BeanContext beanContext) throws ApplicationException {
        try {
            InstanceContext context = beanContext.newInstance();
            if (context.getBean() instanceof SessionBean) {
                Operation originalOperation = callContext.getCurrentOperation();
                try {
                    callContext.setCurrentOperation(Operation.CREATE);
                    Method create = beanContext.getCreateMethod();
                    InterceptorStack ejbCreate = new InterceptorStack(context.getBean(), create, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                    ejbCreate.invoke(new Object[0]);
                }
                finally {
                    callContext.setCurrentOperation(originalOperation);
                }
            }
            return new Instance(context.getBean(), context.getInterceptors(), context.getCreationalContext());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            String t = "The bean instance " + beanContext.getDeploymentID() + " threw a system exception:" + e;
            logger.error(t, e);
            throw new ApplicationException(new RemoteException("Cannot obtain a free instance.", e));
        }
    }

    public void poolInstance(ThreadContext callContext, Object bean) throws OpenEJBException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        Instance instance = (Instance)Instance.class.cast(bean);
        BeanContext beanContext = callContext.getBeanContext();
        Data data = (Data)beanContext.getContainerData();
        Pool<Instance> pool = data.getPool();
        if (instance.getPoolEntry() != null) {
            pool.push(instance.getPoolEntry());
        } else {
            pool.push(instance);
        }
    }

    public void discardInstance(ThreadContext callContext, Object bean) throws SystemException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        Instance instance = (Instance)Instance.class.cast(bean);
        BeanContext beanContext = callContext.getBeanContext();
        Data data = (Data)beanContext.getContainerData();
        if (null != data) {
            Pool<Instance> pool = data.getPool();
            pool.discard(instance.getPoolEntry());
        }
    }

    private void freeInstance(ThreadContext callContext, Instance instance) {
        try {
            callContext.setCurrentOperation(Operation.PRE_DESTROY);
            BeanContext beanContext = callContext.getBeanContext();
            Method remove = instance.bean instanceof SessionBean ? removeSessionBeanMethod : null;
            List<InterceptorData> callbackInterceptors = beanContext.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
            interceptorStack.invoke(new Object[0]);
            if (instance.creationalContext != null) {
                instance.creationalContext.release();
            }
        }
        catch (Throwable re) {
            logger.error("The bean instance " + instance + " threw a system exception:" + re, re);
        }
    }

    public void deploy(BeanContext beanContext) throws OpenEJBException {
        ObjectName objectName;
        Options options = new Options(beanContext.getProperties());
        Duration accessTimeout = this.getDuration(options, "Timeout", this.accessTimeout, TimeUnit.MILLISECONDS);
        accessTimeout = this.getDuration(options, "AccessTimeout", accessTimeout, TimeUnit.MILLISECONDS);
        Duration closeTimeout = this.getDuration(options, "CloseTimeout", this.closeTimeout, TimeUnit.MINUTES);
        ObjectRecipe recipe = PassthroughFactory.recipe(new Pool.Builder(this.poolBuilder));
        recipe.allow(Option.CASE_INSENSITIVE_FACTORY);
        recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        recipe.setAllProperties((Map)beanContext.getProperties());
        Pool.Builder builder = (Pool.Builder)recipe.create();
        this.setDefault(builder.getMaxAge(), TimeUnit.HOURS);
        this.setDefault(builder.getIdleTimeout(), TimeUnit.MINUTES);
        this.setDefault(builder.getInterval(), TimeUnit.MINUTES);
        StatelessSupplier supplier = new StatelessSupplier(beanContext);
        builder.setSupplier(supplier);
        builder.setExecutor(this.executor);
        Data data = new Data(builder.build(), accessTimeout, closeTimeout);
        beanContext.setContainerData(data);
        beanContext.set(EJBContext.class, data.sessionContext);
        try {
            Context context = beanContext.getJndiEnc();
            context.bind("comp/EJBContext", (Object)data.sessionContext);
            context.bind("comp/WebServiceContext", (Object)new EjbWsContext(data.sessionContext));
            context.bind("comp/TimerService", (Object)new TimerServiceWrapper());
        }
        catch (NamingException e) {
            throw new OpenEJBException("Failed to bind EJBContext/WebServiceContext/TimerService", e);
        }
        int min = builder.getMin();
        long maxAge = builder.getMaxAge().getTime(TimeUnit.MILLISECONDS);
        double maxAgeOffset = builder.getMaxAgeOffset();
        StatsInterceptor stats = new StatsInterceptor(beanContext.getBeanClass());
        beanContext.addSystemInterceptor(stats);
        MBeanServer server = LocalMBeanServer.get();
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "openejb");
        jmxName.set("J2EEApplication", null);
        jmxName.set("EJBModule", beanContext.getModuleID());
        jmxName.set("StatelessSessionBean", beanContext.getEjbName());
        jmxName.set("j2eeType", "");
        jmxName.set("name", beanContext.getEjbName());
        try {
            objectName = jmxName.set("j2eeType", "Invocations").build();
            server.registerMBean(new ManagedMBean(stats), objectName);
            data.add(objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", e);
        }
        try {
            objectName = jmxName.set("j2eeType", "Pool").build();
            server.registerMBean(new ManagedMBean(data.pool), objectName);
            data.add(objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", e);
        }
        if (!options.get("BackgroundStartup", false) && min > 0) {
            ExecutorService es = Executors.newFixedThreadPool(min);
            for (int i = 0; i < min; ++i) {
                es.submit(new InstanceCreatorRunnable(maxAge, i, min, maxAgeOffset, data, supplier));
            }
            es.shutdown();
            try {
                es.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                logger.error("can't fill the stateless pool", e);
            }
        }
        data.getPool().start();
    }

    private void setDefault(Duration duration, TimeUnit unit) {
        if (duration.getUnit() == null) {
            duration.setUnit(unit);
        }
    }

    private Duration getDuration(Options options, String property, Duration defaultValue, TimeUnit defaultUnit) {
        String s = options.get(property, defaultValue.toString());
        Duration duration = new Duration(s);
        if (duration.getUnit() == null) {
            duration.setUnit(defaultUnit);
        }
        return duration;
    }

    public void undeploy(BeanContext beanContext) {
        Data data = (Data)beanContext.getContainerData();
        if (data == null) {
            return;
        }
        MBeanServer server = LocalMBeanServer.get();
        for (ObjectName objectName : data.jmxNames) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to unregister MBean " + objectName);
            }
        }
        try {
            if (!data.closePool()) {
                logger.error("Timed-out waiting for stateless pool to close: for deployment '" + beanContext.getDeploymentID() + "'");
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        beanContext.setContainerData(null);
    }

    static {
        Method foundRemoveMethod;
        logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
        try {
            foundRemoveMethod = SessionBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            foundRemoveMethod = null;
        }
        removeSessionBeanMethod = foundRemoveMethod;
    }

    private class InstanceCreatorRunnable
    implements Runnable {
        private long maxAge;
        private long iteration;
        private double maxAgeOffset;
        private long min;
        private Data data;
        private StatelessSupplier supplier;

        private InstanceCreatorRunnable(long maxAge, long iteration, long min, double maxAgeOffset, Data data, StatelessSupplier supplier) {
            this.maxAge = maxAge;
            this.iteration = iteration;
            this.min = min;
            this.maxAgeOffset = maxAgeOffset;
            this.data = data;
            this.supplier = supplier;
        }

        @Override
        public void run() {
            Instance obj = this.supplier.create();
            if (obj != null) {
                long offset = this.maxAge > 0L ? (long)((double)this.maxAge / this.maxAgeOffset * (double)this.min * (double)this.iteration) % this.maxAge : 0L;
                this.data.getPool().add(obj, offset);
            }
        }
    }

    private final class Data {
        private final Pool<Instance> pool;
        private final Duration accessTimeout;
        private final Duration closeTimeout;
        private final List<ObjectName> jmxNames = new ArrayList<ObjectName>();
        private final SessionContext sessionContext;

        private Data(Pool<Instance> pool, Duration accessTimeout, Duration closeTimeout) {
            this.pool = pool;
            this.accessTimeout = accessTimeout;
            this.closeTimeout = closeTimeout;
            this.sessionContext = new StatelessContext(StatelessInstanceManager.this.securityService, new Flushable(){

                @Override
                public void flush() throws IOException {
                    Data.this.getPool().flush();
                }
            });
        }

        public Duration getAccessTimeout() {
            return this.accessTimeout;
        }

        public Pool.Entry poolPop() throws InterruptedException, TimeoutException {
            return this.pool.pop(this.accessTimeout.getTime(), this.accessTimeout.getUnit());
        }

        public Pool<Instance> getPool() {
            return this.pool;
        }

        public boolean closePool() throws InterruptedException {
            return this.pool.close(this.closeTimeout.getTime(), this.closeTimeout.getUnit());
        }

        public ObjectName add(ObjectName name) {
            this.jmxNames.add(name);
            return name;
        }
    }

    private class StatelessSupplier
    implements Pool.Supplier<Instance> {
        private final BeanContext beanContext;

        private StatelessSupplier(BeanContext beanContext) {
            this.beanContext = beanContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard(Instance instance, Pool.Event reason) {
            ThreadContext ctx = new ThreadContext(this.beanContext, null);
            ThreadContext oldCallContext = ThreadContext.enter(ctx);
            try {
                StatelessInstanceManager.this.freeInstance(ctx, instance);
            }
            finally {
                ThreadContext.exit(oldCallContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Instance create() {
            ThreadContext ctx = new ThreadContext(this.beanContext, null);
            ThreadContext oldCallContext = ThreadContext.enter(ctx);
            try {
                Instance instance = StatelessInstanceManager.this.ceateInstance(ctx, ctx.getBeanContext());
                return instance;
            }
            catch (OpenEJBException e) {
                logger.error("Unable to fill pool: for deployment '" + this.beanContext.getDeploymentID() + "'", e);
            }
            finally {
                ThreadContext.exit(oldCallContext);
            }
            return null;
        }
    }
}

