/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.openejb.core.timer.CalendarTimerData;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.IntervalTimerData;
import org.apache.openejb.core.timer.SingleActionTimerData;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.timer.TimerStoreException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MemoryTimerStore
implements TimerStore {
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private final Map<Long, TimerData> taskStore = new ConcurrentHashMap<Long, TimerData>();
    private final Map<Transaction, TimerDataView> tasksByTransaction = new ConcurrentHashMap<Transaction, TimerDataView>();
    private final AtomicLong counter = new AtomicLong(0L);
    private final TransactionManager transactionManager;

    public MemoryTimerStore(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public TimerData getTimer(String deploymentId, long timerId) {
        try {
            TimerDataView tasks = this.getTasks();
            TimerData timerData = tasks.getTasks().get(new Long(timerId));
            return timerData;
        }
        catch (TimerStoreException e) {
            return null;
        }
    }

    @Override
    public Collection<TimerData> getTimers(String deploymentId) {
        try {
            TimerDataView tasks = this.getTasks();
            ArrayList<TimerData> timerDatas = new ArrayList<TimerData>(tasks.getTasks().values());
            return timerDatas;
        }
        catch (TimerStoreException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public Collection<TimerData> loadTimers(EjbTimerServiceImpl timerService, String deploymentId) throws TimerStoreException {
        TimerDataView tasks = this.getTasks();
        ArrayList<TimerData> timerDatas = new ArrayList<TimerData>(tasks.getTasks().values());
        return timerDatas;
    }

    @Override
    public void addTimerData(TimerData timerData) throws TimerStoreException {
        this.getTasks().addTimerData(timerData);
    }

    @Override
    public TimerData createCalendarTimer(EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, ScheduleExpression scheduleExpression, TimerConfig timerConfig) throws TimerStoreException {
        long id = this.counter.incrementAndGet();
        CalendarTimerData timerData = new CalendarTimerData(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig, scheduleExpression);
        this.getTasks().addTimerData(timerData);
        return timerData;
    }

    @Override
    public TimerData createIntervalTimer(EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws TimerStoreException {
        long id = this.counter.incrementAndGet();
        IntervalTimerData timerData = new IntervalTimerData(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig, initialExpiration, intervalDuration);
        this.getTasks().addTimerData(timerData);
        return timerData;
    }

    @Override
    public TimerData createSingleActionTimer(EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, Date expiration, TimerConfig timerConfig) throws TimerStoreException {
        long id = this.counter.incrementAndGet();
        SingleActionTimerData timerData = new SingleActionTimerData(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig, expiration);
        this.getTasks().addTimerData(timerData);
        return timerData;
    }

    @Override
    public void removeTimer(long id) {
        try {
            this.getTasks().removeTimerData(new Long(id));
        }
        catch (TimerStoreException e) {
            log.warning("Unable to remove timer data from memory store", e);
        }
    }

    @Override
    public void updateIntervalTimer(TimerData timerData) {
    }

    private TimerDataView getTasks() throws TimerStoreException {
        Transaction transaction = null;
        int status = 6;
        try {
            transaction = this.transactionManager.getTransaction();
            if (transaction != null) {
                status = transaction.getStatus();
            }
        }
        catch (SystemException e) {
            // empty catch block
        }
        if (status != 0 && status != 1) {
            return new LiveTimerDataView();
        }
        TxTimerDataView tasks = (TxTimerDataView)this.tasksByTransaction.get(transaction);
        if (tasks == null) {
            tasks = new TxTimerDataView(transaction);
            this.tasksByTransaction.put(transaction, tasks);
        }
        return tasks;
    }

    private class TxTimerDataView
    implements Synchronization,
    TimerDataView {
        private final Map<Long, TimerData> add = new TreeMap<Long, TimerData>();
        private final Set<Long> remove = new TreeSet<Long>();
        private final Lock lock = new ReentrantLock();
        private final RuntimeException concurentException;
        private final WeakReference<Transaction> tansactionReference;

        public TxTimerDataView(Transaction transaction) throws TimerStoreException {
            this.lock.lock();
            this.concurentException = new IllegalThreadStateException("Object can only be invoked by Thread[" + Thread.currentThread().getName() + "] in Transaction[" + transaction + "]");
            this.concurentException.fillInStackTrace();
            try {
                transaction.registerSynchronization((Synchronization)this);
                this.tansactionReference = new WeakReference<Transaction>(transaction);
            }
            catch (RollbackException e) {
                throw new TimerStoreException("Transaction has been rolled back");
            }
            catch (SystemException e) {
                throw new TimerStoreException("Error registering transaction synchronization callback");
            }
        }

        private void checkThread() {
            if (!this.lock.tryLock()) {
                throw new IllegalStateException("Illegal access by Thread[" + Thread.currentThread().getName() + "]", this.concurentException);
            }
        }

        @Override
        public Map<Long, TimerData> getTasks() {
            this.checkThread();
            TreeMap<Long, TimerData> allTasks = new TreeMap<Long, TimerData>();
            allTasks.putAll(MemoryTimerStore.this.taskStore);
            for (Long key : this.remove) {
                allTasks.remove(key);
            }
            allTasks.putAll(this.add);
            return Collections.unmodifiableMap(allTasks);
        }

        @Override
        public void addTimerData(TimerData timerData) {
            this.checkThread();
            Long timerId = new Long(timerData.getId());
            this.remove.remove(timerId);
            this.add.put(timerId, timerData);
        }

        @Override
        public void removeTimerData(Long timerId) {
            this.checkThread();
            this.add.remove(timerId);
            this.remove.add(timerId);
        }

        public void beforeCompletion() {
            this.checkThread();
        }

        public void afterCompletion(int status) {
            this.checkThread();
            if (status != 3) {
                return;
            }
            MemoryTimerStore.this.taskStore.putAll(this.add);
            MemoryTimerStore.this.taskStore.keySet().removeAll(this.remove);
            MemoryTimerStore.this.tasksByTransaction.remove(this.tansactionReference.get());
        }
    }

    private class LiveTimerDataView
    implements TimerDataView {
        private LiveTimerDataView() {
        }

        @Override
        public Map<Long, TimerData> getTasks() {
            return new TreeMap<Long, TimerData>(MemoryTimerStore.this.taskStore);
        }

        @Override
        public void addTimerData(TimerData timerData) {
            MemoryTimerStore.this.taskStore.put(new Long(timerData.getId()), timerData);
        }

        @Override
        public void removeTimerData(Long timerId) {
            MemoryTimerStore.this.taskStore.remove(timerId);
        }
    }

    private static interface TimerDataView {
        public Map<Long, TimerData> getTasks();

        public void addTimerData(TimerData var1);

        public void removeTimerData(Long var1);
    }
}

