/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.concurrent.ThreadFactory;
import org.apache.openejb.util.Join;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String name;
    private transient int ids;

    public DaemonThreadFactory(Object ... name) {
        this.name = Join.join(" ", name);
    }

    public DaemonThreadFactory(Class ... clazz) {
        this(DaemonThreadFactory.asStrings(clazz));
    }

    private static Object[] asStrings(Class[] clazz) {
        Object[] strings = new String[clazz.length];
        int i = 0;
        for (Class c : clazz) {
            strings[i++] = c.getSimpleName();
        }
        return strings;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(runnable, this.name + " thread " + this.ids++);
        t.setDaemon(true);
        return t;
    }
}

